% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inside.R
\name{inside_binom}
\alias{inside_binom}
\alias{inside_multinom}
\title{Check Whether Choice Frequencies are in Polytope}
\usage{
inside_binom(k, n, A, b, V)

inside_multinom(k, options, A, b, V)
}
\arguments{
\item{k}{choice frequencies.
For \code{inside_binom}: per item type (e.g.: a1,b1,c1,..)
For \code{inside_multinom}: for all choice options ordered by item type
(e.g., for ternary choices: a1,a2,a3, b1,b2,b3,..)}

\item{n}{only for \code{inside_binom}: number of choices per item type.}

\item{A}{a matrix with one row for each linear inequality constraint and one
column for each of the free parameters. The parameter space is defined
as all probabilities \code{x} that fulfill the order constraints  \code{A*x <= b}.}

\item{b}{a vector of the same length as the number of rows of \code{A}.}

\item{V}{a matrix of vertices (one per row) that define the polytope of
admissible parameters as the convex hull over these points
(if provided, \code{A} and \code{b} are ignored).
Similar as for \code{A}, columns of \code{V} omit the last value for each
multinomial condition (e.g., a1,a2,a3,b1,b2 becomes a1,a2,b1).
Note that this method is comparatively slow since it solves linear-programming problems
to test whether a point is inside  a polytope (Fukuda, 2004) or to run the Gibbs sampler.}

\item{options}{only for \code{inside_multinom}: number of response options per item type.}
}
\description{
Computes relative choice frequencies and checks whether these are in the polytope defined
via (1) \code{A*x <= b} or (2) by the convex hull of a set of vertices \code{V}.
}
\examples{
############ binomial
# x1<x2<x3<.50:
A <- matrix(c(
  1, -1, 0,
  0, 1, -1,
  0, 0, 1
), ncol = 3, byrow = TRUE)
b <- c(0, 0, .50)
k <- c(0, 1, 5)
n <- c(10, 10, 10)
inside_binom(k, n, A, b)

############ multinomial
# two ternary choices:
#     (a1,a2,a3,   b1,b2,b3)
k <- c(1, 4, 10, 5, 9, 1)
options <- c(3, 3)
# a1<b1, a2<b2, no constraints on a3, b3
A <- matrix(c(
  1, -1, 0, 0,
  0, 0, 1, -1
), ncol = 4, byrow = TRUE)
b <- c(0, 0)
inside_multinom(k, options, A, b)

# V-representation:
V <- matrix(c(
  0, 0, 0, 0,
  0, 0, 0, 1,
  0, 1, 0, 0,
  0, 0, 1, 1,
  0, 1, 0, 1,
  1, 1, 0, 0,
  0, 1, 1, 1,
  1, 1, 0, 1,
  1, 1, 1, 1
), 9, 4, byrow = TRUE)
inside_multinom(k, options, V = V)
}
\seealso{
\code{\link{inside}}
}
