% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-docs.R
\docType{data}
\name{billing2016_suppfig4g}
\alias{billing2016_suppfig4g}
\title{Mass spectrometry intensities by stem cell type}
\format{
A matrix with 13 rows and 9 columns.  Rows represent genes, columns
represent experiments and are split by:
\enumerate{
\item{The type of stem cell experimented on. "ESC" means embryonic stem cell;
"ESC-MSC" means mesenchymal stem cell derived from an embryonic stem cell;
"BM-MSC" means mesenchymal stem cell derived from bone marrow.}
\item{The experimental replicate.}
}
Values in the matrix are intensities of proteins coresponding to the genes,
as measured by mass spectrometry.
}
\description{
This data was used to create Supplementary Figure 4g of Billing 2016 (see
references).
}
\details{
A matrix of log base 10 protein intensities as measured by mass spectrometry
proteomics experiments on embryonic and mesenchymal stem cells.
}
\examples{
color_scale <- grDevices::cm.colors(25)
heatmap(
  billing2016_suppfig4g,
  margins = c(12, 5), col = color_scale,
  cexRow = 0.5, cexCol = 0.4)
}
\references{
Billing AM, Ben Hamidane H, Dib SS, et al. Comprehensive transcriptomic and
proteomic characterization of human mesenchymal stem cells reveals source
specific cellular markers. Scientific Reports. 2016;6:21507.
doi:10.1038/srep21507.

Article text available at:
\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4746666}

Supplementary figures available at:
\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4746666/bin/srep21507-s1.pdf}
}
\seealso{
\code{\link{billing2016_suppfig4e}}
}
