% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{clean.graph}
\alias{clean.graph}
\title{cleanup dependence structure graph}
\usage{
clean.graph(g, only.level = NULL, simplify.pairs = TRUE,
  drop.label.pairs = FALSE)
}
\arguments{
\item{g}{graph, created by \code{\link{dependence.structure}}}

\item{only.level}{integer vector, if provided all edges and dependency nodes corresponding to dependence orders not given in 'only.level' are removed}

\item{simplify.pairs}{boolean, if true dependency nodes which are only connected to two variables are turned into edges}

\item{drop.label.pairs}{boolean, if true the labels for edges indicating pairwise dependence are removed}
}
\value{
graph
}
\description{
Given a dependence structure graph: vertices representing the multivariances of only two vertices can be turned into an edge labeled with the label of the vertex. Moreover, only subsets of the graph can be selected.
}
\details{
Note: The option 'only.level' works only properly for a full dependence structure graph, in the case of a clustered dependence structure graph dependency nodes representing a cluster might be removed.
}
\examples{
N = 200
y = coins(N,2)
x = cbind(y,y,y)

ds = dependence.structure(x,structure.type = "clustered")
plot(clean.graph(ds$graph))
plot(clean.graph(ds$graph,only.level = 2))
plot(clean.graph(ds$graph,only.level = 3)) # of limited use for a clustered graph,
# i.e., here the three-dependence node without edges indicates that
# all edges were connected to clusters

ds = dependence.structure(x,structure.type = "full")
plot(clean.graph(ds$graph))
plot(clean.graph(ds$graph,drop.label.pairs = TRUE))
plot(clean.graph(ds$graph,only.level = 2))
plot(clean.graph(ds$graph,only.level = 2,drop.label.pairs = TRUE))
plot(clean.graph(ds$graph,only.level = 3))

}
