% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_over_Pi.R
\name{optimize_over_Pi}
\alias{optimize_over_Pi}
\title{Exponentiated gradient descent for estimating Pi}
\usage{
optimize_over_Pi(logphi1, logphi2, row, col, max.iter = 1000,
  stepsz = 0.001)
}
\arguments{
\item{logphi1}{log(phi1), where the n x K1 matrix phi1 is defined in equation (2.9)}

\item{logphi2}{log(phi1), where the n x K2 matrix phi2 is defined in equation (2.9)}

\item{row}{K1-vector containing the estimated View 1 mixture component probabilities}

\item{col}{K2-vector containing the estimated View 2 mixture component probabilities}

\item{max.iter}{Maximum number of iterations to be run.}

\item{stepsz}{Fixed step size to be used in the optimization; see Appendix B for details.}
}
\value{
List of:
\item{Pi.est}{Estimate of Pi; maximizes the log-likelihood function of X1 and X2.}
\item{obj}{The log-likelihood function evaluated at Pi.est.}
}
\description{
Implements the optimization algorithm for solving equation (2.8)
in Section 2.3.2 of Gao et al. (2019) "Are Clusterings of Multiple
Data Views Independent?" Derivation of the algorithm is given in Appendix B.
}
\examples{
# Generate two-view Gaussian mixture model data with Pi = I/3
set.seed(1)
n <- 100
sig <- 0.5
p <- 2
K <- 3
mu1 <- cbind(c(2, 0), c(0, 2),  c(2, -2), c(-2, 0), c(0, -2), c(-2, 2))
mu2 <- cbind(c(-2, 0), c(0, -2), c(-2, 2), c(2, 0), c(0, 2), c(2, -2))
cl <- sample(1:K, n, replace=TRUE)
x <- list(matrix(sig* rnorm(n*p), n, p) + t(mu1)[cl, ],
matrix(sig * rnorm(n*p), n, p) + t(mu2)[cl, ])

# Cluster each view
library(mclust)
EM.View1 <- Mclust(x[[1]], G=3, modelNames=c("EII"))
EM.View2 <- Mclust(x[[2]], G=3, modelNames=c("EII"))

# Constructs inputs to algorithm
logphi1 <-  cdens("EII", x[[1]], logarithm=TRUE, EM.View1$parameters)
logphi2 <-  cdens("EII", x[[2]], logarithm=TRUE, EM.View2$parameters)
pi1.est <- EM.View1$parameters$pro
pi2.est <- EM.View2$parameters$pro

# Estimates Pi
Pi.est <- optimize_over_Pi(logphi1, logphi2, pi1.est, pi2.est)
Pi.est$Pi

}
\references{
Gao, L.L., Bien, J., Witten, D. (2019) Are Clusterings of Multiple Data Views Independent?
Biostatistics <DOI:10.1093/biostatistics/kxz001>.
}
