% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mv_memberships_gen.R
\name{mv_memberships_gen}
\alias{mv_memberships_gen}
\title{Generates multi-view subgroup memberships}
\usage{
mv_memberships_gen(n, Pi)
}
\arguments{
\item{n}{number of observations}

\item{Pi}{K1 x K2 matrix where the (k, k')th entry contains the probability of an observation 
belonging to subgroup k in View 1 and subgroup k' in View 2}
}
\value{
n x 2 matrix where the first column contains subgroup memberships for View 1 (Z1)
and the second column contains subgroup memberships for View 2 (Z2).
}
\description{
Generates subgroup membership pairs (Z1, Z2) for a multi-view data set with 
n observations and two views.
}
\examples{
Pi <- tcrossprod(c(0.5, 0.5), c(0.25, 0.25, 0.5))
n <- 25
mv_memberships_gen(n, Pi)

}
\references{
Gao, L.L., Bien, J., Witten, D. (2019) Are Clusterings of Multiple Data Views Independent?
to appear in Biostatistics, <DOI:10.1093/biostatistics/kxz001>

Gao, L.L., Witten, D., Bien, J. Testing for Association in Multi-View Network Data, preprint.
}
