% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mv_sbm_gmm_gen.R
\name{mv_sbm_gmm_gen}
\alias{mv_sbm_gmm_gen}
\title{Generates data from a stochastic block model for a network view and a multivariate view}
\usage{
mv_sbm_gmm_gen(n, Pi, theta1, mu2, Sigma2, sparse = FALSE)
}
\arguments{
\item{n}{number of observations}

\item{Pi}{K1 x K2 matrix where the (k, k')th entry contains the probability of an observation 
belonging to community k in View 1 and cluster k' in View 2}

\item{theta1}{K1 x K1 matrix containing the between-community edge probabilities for View 1}

\item{mu2}{mu2 p2 x K2 matrix where the columns contain the K2 cluster means in View 2}

\item{Sigma2}{p2 x p2 matrix containing the covariance matrix for View 2}

\item{sparse}{If true, return matrix views in sparseMatrix format}
}
\value{
A list containing the following components:
\item{data}{A list with two items: the view 1 n x n adjacency matrix and 
the view 2 n x p multivariate data set }
\item{communities}{A list with two items: the view 1 community memberships and 
the view 2 cluster memberships}
}
\description{
Generates data from a stochastic block model for a network view and a multivariate view
with n observations. The data for the multivariate view is drawn from a Gaussian
mixture model.
}
\examples{
# 50 draws from a stochastic block model for a network view and a multivariate view
# where the communities and the clusters are independent
n <- 50
Pi <- tcrossprod(c(0.5, 0.5), c(0.5, 0.5))
theta1 <- rbind(c(0.5, 0.1), c(0.1, 0.5))
mu2 <- cbind(c(2, 2), c(-2, 2))
Sigma2 <- diag(rep(0.5, 2))

mv_sbm_gmm_gen(n, Pi, theta1, mu2, Sigma2)

}
\references{
Gao, L.L., Witten, D., Bien, J. Testing for Association in Multi-View Network Data, preprint.
}
