% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estparmcd.R
\name{estparmcd}
\alias{estparmcd}
\title{Estimation of the Parameters of a Multivariate Cauchy Distribution}
\usage{
estparmcd(x, eps = 1e-6)
}
\arguments{
\item{x}{numeric matrix or data frame.}

\item{eps}{numeric. Precision for the estimation of the parameters.}
}
\value{
A list of 2 elements:
\itemize{
\item \code{mu} the mean vector.
\item \code{Sigma}: symmetric positive-definite matrix. The correlation matrix.
}
with two attributes \code{attr(, "epsilon")} (precision of the result) and \code{attr(, "k")} (number of iterations).
}
\description{
Estimation of the mean vector and correlation matrix of a multivariate Cauchy distribution (MCD).
}
\details{
The EM method is used to estimate the parameters.
}
\examples{
mu <- c(0, 1, 4)
Sigma <- matrix(c(1, 0.6, 0.2, 0.6, 1, 0.3, 0.2, 0.3, 1), nrow = 3)
x <- rmcd(100, mu, Sigma)

# Estimation of the parameters
estparmcd(x)

}
\references{
Doğru, F., Bulut, Y. M. and Arslan, O. (2018).
Doubly reweighted estimators for the parameters of the multivariate t-distribution.
Communications in Statistics - Theory and Methods. 47.
\doi{10.1080/03610926.2018.1445861}.
}
\seealso{
\code{\link{dmcd}}: probability density of a MTD

\code{\link{rmcd}}: random generation from a MTD.
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
