% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_kmeans.R
\name{classify_kmeans}
\alias{classify_kmeans}
\title{Muscle synergy classification with k-means}
\usage{
classify_kmeans(x, MSE_lim = 0.001, interactive = TRUE, show_plot = TRUE)
}
\arguments{
\item{x}{A list of \code{musclesyneRgies} objects}

\item{MSE_lim}{Mean squared error threshold for determining the minimum number of clusters}

\item{interactive}{Logical, ask for interactive re-ordering or go fully automated?}

\item{show_plot}{Logical, to decide whether plots should be plotted in the active graphic device}
}
\value{
List of \code{musclesyneRgies} objects, each with elements:\cr
\itemize{
\item \code{syns} factorisation rank or minimum number of synergies\cr
\item \code{M} motor modules (time-invariant coefficients)\cr
\item \code{P} motor primitives (time-dependent coefficients)\cr
\item \code{V} original data\cr
\item \code{Vr} reconstructed data\cr
\item \code{iterations} number of iterations to convergence\cr
\item \code{R2} quality of reconstruction (coefficient of determination)
\item \code{rank_type} was the rank \code{fixed} or \code{variable}?\cr
\item \code{classification} classification type (\code{k-means})
}
}
\description{
Muscle synergy classification with k-means
}
\details{
This function must be applied to a list with a sufficient amount of trials, otherwise the
classification will not work. Typically, at least 10 trials for the same condition are needed
for satisfactory classification. If \code{show_plot} is TRUE (default) plots are also shown in the active graphic device.
Plots can then be saved with the preferred export method, such as \code{ggplot2::ggsave}.
}
\examples{
# Load some data
data(SYNS)
# Classify synergies
SYNS_classified <- classify_kmeans(SYNS,
  interactive = FALSE
)
}
