% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimize_VL.R
\name{flex_points}
\alias{flex_points}
\title{Voice-leading inflection points}
\usage{
flex_points(
  set,
  goal = NULL,
  method = c("taxicab", "euclidean", "chebyshev", "hamming"),
  subdivide = 100,
  edo = 12,
  rounder = 10
)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{goal}{Numeric vector like set: what is the tn-type of the voice leading's destination?
Defaults to \code{NULL}, in which case the function uses \code{set} as the tn-type.}

\item{method}{What distance metric should be used? Defaults to \code{"taxicab"}
but can be \code{"euclidean"}, \code{"chebyshev"}, or \code{"hamming"}.}

\item{subdivide}{Numeric: how many small amounts should each \code{edo} step be divided into? Defaults to \code{100}.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Numeric vector of the transposition indices that are inflection points. Length of result
matches size of \code{set}, except in the case of some multisets, which can have fewer inflection points.
}
\description{
When considering an n-note set's potential voice leadings to transpositions of a goal (along the lines
of \code{\link[=vl_rolodex]{vl_rolodex()}} and \code{\link[=tndists]{tndists()}}), there will always be some transposition in continuous pc-space
for which a given modal rotation is the best potential target for voice leading. (That is, there is
always some \code{x} such that \code{whichmodebest(set, tn(set, x)) == k} for any \code{k} between \code{1} and \code{n}.)
Moreover, there will always be a transposition level at the boundary between two different ideal modes,
where both modes require the same amount of voice leading work. \code{flex_points()} identifies those
inflection points where one mode gives way to another. (Note: \code{flex_points()} identifies these points
by numerical approximation, so it may not give exact values. For more precision, increase the value
of \code{subdivide}.)
}
\examples{
major_triad_12tet <- c(0, 4, 7)
major_triad_just <- z(1, 5/4, 3/2)
major_triad_19tet <- c(0, 6, 11)

flex_points(major_triad_12tet, method="euclidean", subdivide=1000)
flex_points(major_triad_just, method="euclidean", subdivide=1000)

# Note that the units of measurement correspond to edo.
# The value 3.16 here corresponds to exactly 1/6 of an octave.
flex_points(major_triad_19tet, edo=19)

}
