% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_theory.R
\name{tn}
\alias{tn}
\alias{tni}
\alias{startzero}
\alias{charm}
\title{Transposition and Inversion}
\usage{
tn(set, n, sorted = TRUE, edo = 12, rounder = 10)

tni(set, n, edo = 12, sorted = TRUE)

startzero(set, sorted = TRUE, edo = 12, rounder = 10)

charm(set, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{n}{Numeric value (not necessarily an integer!) representing the
index of transposition or inversion.}

\item{sorted}{Do you want the result to be in ascending order? Boolean,
defaults to \code{TRUE}.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Numeric vector of same length as \code{set}
}
\description{
Calculate the classic operations on pitch-class sets \eqn{T_n} and
\eqn{T_n I}. That is, \code{tn} adds a constant to all elements in a set
modulo the octave, and \code{tni} essentially multiplies a set by \code{-1} (modulo
the octave) and then adds a constant (modulo the octave). If \code{sorted} is
\code{TRUE} (as is default), the resulting set is listed in ascending order,
but sometimes it can be useful to track transformational voice leadings,
in which case you should set \code{sorted} to \code{FALSE}.

\code{startzero} transposes a set so that its first element is \code{0}.
(Note that this is different from \code{\link[=tnprime]{tnprime()}} because it doesn't attempt
to find the most compact form of the set. See examples for the contrast.)

Sometimes you just want to invert a set and you don't care what the
index is. \code{charm} is a quick way to do this, giving a name to
the transposition-class of \eqn{T_0 I} of the set.
(The name \code{charm} is a reference to "strange" and "charm" quarks in
particle physics: I like these as names for the "a" and "b" forms of
a set class, i.e. the strange common triad is 3-11a = (0, 3, 7)
and the charm common triad is 3-11b = (0, 4, 7). The name of the function
\code{charm} means that if you input a strange set, you get out a charm set,
but NB also vice versa.)
}
\examples{
c_major <- c(0, 4, 7)
tn(c_major, 2)
tn(c_major, -10)
tni(c_major, 7)
tni(c_major, 7, sorted=FALSE)
tn(c(0, 1, 6, 7), 6)
tn(c(0, 1, 6, 7), 6, sorted=FALSE)

##### Difference between startzero and tnprime
e_maj7 <- c(4, 8, 11, 3)
startzero(e_maj7)
tnprime(e_maj7)
isTRUE(all.equal(tnprime(e_maj7), charm(e_maj7))) # True because inversionally symmetrical

##### Derive minimal voice leading from ionian to lydian
ionian <- c(0, 2, 4, 5, 7, 9, 11)
lydian <- rotate(tn(ionian, 7, sorted=FALSE), 3)
lydian - ionian
}
