/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.wizard;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.spi.wizard.SimpleWizardInfo;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardImplementation;
import org.netbeans.spi.wizard.WizardObserver;
import org.netbeans.spi.wizard.WizardPanelProvider;

final class SimpleWizard
implements WizardImplementation {
    private final List listenerList = Collections.synchronizedList(new LinkedList());
    private final Map ids2panels = new HashMap();
    final SimpleWizardInfo info;
    private String currID = null;
    private boolean subwizard;

    public SimpleWizard(WizardPanelProvider prov) {
        this(new SimpleWizardInfo(prov), false);
    }

    public SimpleWizard(SimpleWizardInfo info) {
        this.info = info;
        info.setWizard(this);
    }

    public SimpleWizard(SimpleWizardInfo info, boolean subwizard) {
        this.info = info;
        this.subwizard = subwizard;
        info.setWizard(this);
    }

    public void addWizardObserver(WizardObserver observer) {
        this.listenerList.add(observer);
    }

    public void removeWizardObserver(WizardObserver observer) {
        this.listenerList.remove(observer);
    }

    public int getForwardNavigationMode() {
        int result = this.info.getFwdNavMode();
        if (!this.subwizard && (result & 1) != 0 && this.isLastStep()) {
            result = 2;
        }
        return result;
    }

    boolean isLastStep() {
        String[] steps = this.info.getSteps();
        return this.currID != null && steps.length > 0 && this.currID.equals(steps[steps.length - 1]);
    }

    public String[] getAllSteps() {
        String[] allSteps = this.info.getSteps();
        String[] result = new String[allSteps.length];
        System.arraycopy(allSteps, 0, result, 0, allSteps.length);
        return result;
    }

    public String getStepDescription(String id) {
        int idx = Arrays.asList(this.info.getSteps()).indexOf(id);
        if (idx == -1) {
            throw new IllegalArgumentException("Undefined id: " + id);
        }
        return this.info.getDescriptions()[idx];
    }

    public String getLongDescription(String id) {
        return this.info.getLongDescription(id);
    }

    public JComponent navigatingTo(String id, Map settings) {
        JComponent result = (JComponent)this.ids2panels.get(id);
        this.currID = id;
        if (result == null) {
            result = this.info.createPanel(id, settings);
            this.ids2panels.put(id, result);
        } else {
            this.info.update();
            this.info.recycleExistingPanel(id, settings, result);
        }
        this.fireSelectionChanged();
        return result;
    }

    public String getCurrentStep() {
        return this.currID;
    }

    public String getNextStep() {
        if (!this.info.isValid()) {
            return null;
        }
        if ((this.info.getFwdNavMode() & 1) == 0) {
            return null;
        }
        int idx = this.currentStepIndex();
        if (idx < this.info.getSteps().length - 1) {
            return this.info.getSteps()[idx + 1];
        }
        return null;
    }

    public String getPreviousStep() {
        int idx = this.currentStepIndex();
        if (idx < this.info.getSteps().length && idx > 0) {
            return this.info.getSteps()[idx - 1];
        }
        return null;
    }

    int currentStepIndex() {
        int idx = 0;
        if (this.currID != null) {
            idx = Arrays.asList(this.info.getSteps()).indexOf(this.currID);
        }
        return idx;
    }

    void fireNavigability() {
        WizardObserver[] listeners = this.listenerList.toArray(new WizardObserver[0]);
        for (int i = listeners.length - 1; i >= 0; --i) {
            WizardObserver l = listeners[i];
            l.navigabilityChanged(null);
        }
    }

    private void fireSelectionChanged() {
        WizardObserver[] listeners = this.listenerList.toArray(new WizardObserver[0]);
        for (int i = listeners.length - 1; i >= 0; --i) {
            WizardObserver l = listeners[i];
            l.selectionChanged(null);
        }
    }

    public Object finish(Map settings) throws WizardException {
        return this.info.finish(settings);
    }

    public boolean cancel(Map settings) {
        return this.info.cancel(settings);
    }

    public String getTitle() {
        return this.info.getTitle();
    }

    public String getProblem() {
        return this.info.getProblem();
    }

    public boolean isBusy() {
        return this.info.isBusy();
    }

    public int hashCode() {
        return this.info.hashCode() ^ 0x11;
    }

    public boolean equals(Object o) {
        if (o instanceof SimpleWizard) {
            return ((SimpleWizard)o).info.equals(this.info);
        }
        return false;
    }

    public String toString() {
        return "SimpleWizard for " + this.info;
    }
}

