/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.mutoss.Method;
import org.mutoss.MethodHandler;
import org.mutoss.MuTossControl;
import org.mutoss.MuTossObject;
import org.mutoss.gui.MuTossMainLabel;

public class MuTossMainPanel
extends JPanel
implements MouseListener,
ActionListener {
    protected JButton jbData = new JButton("Data");
    protected JButton jbModel = new JButton("Model");
    protected JButton jbHypotheses = new JButton("Hypotheses");
    protected JButton jbPValues = new JButton("p-Values");
    protected JButton jbErrorRate = new JButton("Error Rate");
    protected JButton jbAdjPValues = new JButton("Adjusted p-Values");
    protected JButton jbCI = new JButton("Confidence Intervals");
    protected JButton jbRejected = new JButton("Rejected");
    protected JButton jbP0 = new JButton("P0");
    public MuTossMainLabel mlData = new MuTossMainLabel("Please load either data or p-values!");
    public MuTossMainLabel mlModel = new MuTossMainLabel();
    public MuTossMainLabel mlHypotheses = new MuTossMainLabel();
    public MuTossMainLabel mlPValues = new MuTossMainLabel("Please load either data or p-values!");
    public MuTossMainLabel mlErrorRate = new MuTossMainLabel();
    public MuTossMainLabel mlAdjPValues = new MuTossMainLabel();
    public MuTossMainLabel mlCI = new MuTossMainLabel();
    public MuTossMainLabel mlRejected = new MuTossMainLabel();
    public MuTossMainLabel mlP0 = new MuTossMainLabel();

    public MuTossMainPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.jbData, c);
        this.jbData.addMouseListener(this);
        ++c.gridy;
        this.add((Component)this.jbModel, c);
        this.jbModel.addMouseListener(this);
        this.jbModel.setEnabled(false);
        ++c.gridy;
        this.add((Component)this.jbHypotheses, c);
        this.jbHypotheses.addMouseListener(this);
        this.jbHypotheses.setEnabled(false);
        ++c.gridy;
        this.add((Component)this.jbPValues, c);
        this.jbPValues.addMouseListener(this);
        ++c.gridy;
        this.add((Component)this.jbErrorRate, c);
        this.jbErrorRate.addMouseListener(this);
        this.jbErrorRate.setEnabled(false);
        ++c.gridy;
        this.add((Component)this.jbP0, c);
        this.jbP0.addMouseListener(this);
        this.jbP0.setEnabled(false);
        ++c.gridy;
        this.add((Component)this.jbAdjPValues, c);
        this.jbAdjPValues.addMouseListener(this);
        this.jbAdjPValues.setEnabled(false);
        ++c.gridy;
        this.add((Component)this.jbCI, c);
        this.jbCI.addMouseListener(this);
        this.jbCI.setEnabled(false);
        ++c.gridy;
        this.add((Component)this.jbRejected, c);
        this.jbRejected.addMouseListener(this);
        this.jbRejected.setEnabled(false);
        ++c.gridy;
        c.gridy = 0;
        ++c.gridx;
        this.add((Component)this.mlData, c);
        ++c.gridy;
        this.add((Component)this.mlModel, c);
        ++c.gridy;
        this.add((Component)this.mlHypotheses, c);
        ++c.gridy;
        this.add((Component)this.mlPValues, c);
        ++c.gridy;
        this.add((Component)this.mlErrorRate, c);
        ++c.gridy;
        this.add((Component)this.mlP0, c);
        ++c.gridy;
        this.add((Component)this.mlAdjPValues, c);
        ++c.gridy;
        this.add((Component)this.mlCI, c);
        ++c.gridy;
        this.add((Component)this.mlRejected, c);
        ++c.gridy;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
    }

    public static MuTossObject getObj() {
        return MuTossControl.getObj();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        JPopupMenu popupmenu = new JPopupMenu();
        if (event.getSource() == this.jbData) {
            this.createItem(popupmenu, "Load R Object", "load r data");
            popupmenu.addSeparator();
            this.createItem(popupmenu, "Info", "show data info", MuTossMainPanel.getObj().hasData());
        } else if (event.getSource() == this.jbModel) {
            this.createItem(popupmenu, "Load R Object", "load r model");
            popupmenu.addSeparator();
            JMenu modelm = new JMenu("Specify Model");
            JMenu modelm2 = new JMenu("Single endpoint in k groups (k >= 3)");
            this.createItem(modelm2, "Linear model", "model lm");
            modelm.add(modelm2);
            modelm2 = new JMenu("Multiple endpoints in k groups (k >= 1)");
            this.createItem(modelm2, "One-sample t-test for each marginal", "model onesample t");
            this.createItem(modelm2, "Paired t-test for each marginal", "model paired t");
            this.createItem(modelm2, "Two-sample t-test for each marginal", "model twosample");
            this.createItem(modelm2, "F-test for equality of means for each marginal", "model f");
            this.createItem(modelm2, "Multiple endpoints and multiple contrasts", "model hasler");
            modelm.add(modelm2);
            modelm2 = new JMenu("Multiple (linear) regression (single or multiple response(s), k >= 1 covariates)");
            this.createItem(modelm2, "Multiple endpoints, one covariate of interest", "gill1");
            this.createItem(modelm2, "Single endpoints, multiple covariate of interest", "gill2");
            modelm.add(modelm2);
            popupmenu.add(modelm);
            popupmenu.addSeparator();
            this.createItem(popupmenu, "Info", "show model info", MuTossMainPanel.getObj().hasModel());
        } else if (event.getSource() == this.jbHypotheses) {
            this.createItem(popupmenu, "Load R Object", "load r hypotheses");
            popupmenu.addSeparator();
            this.createItem(popupmenu, "All pair (Tukey)", "Tukey", MuTossMainPanel.getObj().hasModel());
            this.createItem(popupmenu, "Comparison to Control (Dunnett)", "Dunnett", MuTossMainPanel.getObj().hasModel());
            this.createItem(popupmenu, "Define Contrasts", "define contrasts", MuTossMainPanel.getObj().hasModel());
        } else if (event.getSource() == this.jbErrorRate) {
            this.createItem(popupmenu, "FWER", "FWER", true);
            this.createItem(popupmenu, "FWER.weak", "FWER_WEAK", true);
            this.createItem(popupmenu, "gFWER", "GFWER", true);
            this.createItem(popupmenu, "FDR", "FDR", true);
            this.createItem(popupmenu, "FDX", "FDX", true);
            this.createItem(popupmenu, "perComparison", "show data info", true);
        } else if (event.getSource() == this.jbPValues) {
            this.createItem(popupmenu, "Load R Object", "load r p-values");
            popupmenu.addSeparator();
            this.createItem(popupmenu, "Info", "info p-values", MuTossMainPanel.getObj().hasPValues());
            for (Method m : MethodHandler.getMethodHandler().getPValueMethods()) {
                this.createItem(popupmenu, m.getLabel(), m.getName());
            }
        } else if (event.getSource() == this.jbAdjPValues) {
            this.createItem(popupmenu, "Info", "ajusted p-values", MuTossMainPanel.getObj().hasAdjPValues());
            popupmenu.addSeparator();
            for (Method m : MethodHandler.getMethodHandler().getAdjustedPValueMethods()) {
                this.createItem(popupmenu, m.getLabel(), m.getName());
            }
        } else if (event.getSource() == this.jbCI) {
            this.createItem(popupmenu, "Visualize", "ci info", MuTossMainPanel.getObj().hasCI());
            for (Method m : MethodHandler.getMethodHandler().getCIMethods()) {
                this.createItem(popupmenu, m.getLabel(), m.getName());
            }
        } else if (event.getSource() == this.jbRejected) {
            this.createItem(popupmenu, "Info", "ajusted p-values", MuTossMainPanel.getObj().hasRejected());
            popupmenu.addSeparator();
            for (Method m : MethodHandler.getMethodHandler().getRejectedMethods()) {
                this.createItem(popupmenu, m.getLabel(), m.getName());
            }
        }
        popupmenu.show(event.getComponent(), event.getX(), event.getY());
    }

    private void createItem(JComponent popupmenu, String itemtitle, String actionCommand) {
        this.createItem(popupmenu, itemtitle, actionCommand, true);
    }

    private void createItem(JComponent popupmenu, String itemtitle, String actionCommand, Boolean enabled) {
        JMenuItem item = new JMenuItem(itemtitle);
        item.setActionCommand(actionCommand);
        item.setEnabled(enabled);
        item.addActionListener(MuTossControl.getInstance());
        popupmenu.add(item);
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public void enableAllButtons() {
        this.jbData.setEnabled(true);
        this.jbModel.setEnabled(true);
        this.jbHypotheses.setEnabled(true);
        this.jbPValues.setEnabled(true);
        this.jbErrorRate.setEnabled(true);
        this.jbAdjPValues.setEnabled(true);
        this.jbCI.setEnabled(true);
        this.jbRejected.setEnabled(true);
        this.jbP0.setEnabled(true);
    }
}

