% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradient_score.R
\name{scoreEstimation}
\alias{scoreEstimation}
\title{Gradient score function}
\usage{
scoreEstimation(obs, loc, vario, weigthFun, dWeigthFun, nCores = 1,
  cl = NULL, ...)
}
\arguments{
\item{obs}{List of vectors exceeding an R-threshold, see Fondeville and Davison (2016) for more details.}

\item{loc}{Matrix of coordinates as given by \code{expand.grid()}.}

\item{vario}{Semi-variogram function taking a vector of coordinates as input.}

\item{weigthFun}{Function of weigths.}

\item{dWeigthFun}{Partial derivative function of \code{weigthFun}.}

\item{nCores}{Number of cores used for the computation}

\item{cl}{Cluster instance as created by \code{makeCluster} of the \code{parallel} package.}

\item{...}{Parameters for \code{weigthFun} and \code{dWeigthFun}.}
}
\value{
Evaluation of the gradient score function for the set of observations \code{obs} and semi-variogram \code{vario}.
}
\description{
Compute the peaks-over-threhold gradient score function for the Brown--Resnick model.
}
\details{
The function computes the gradient score based on the representation developped by Wadsworth et al. (2013).
Margins must have been standardized. The weighting function must differentiable and verify some properties
for consitency, see Fondeville and Davison (2016) for more details.
}
\examples{
#Define variogram function
vario <- function(h){
   1 / 2 * norm(h,type = "2")^1.5
}

#Define locations
loc <- expand.grid(1:4, 1:4)

#Simulate data
obs <- simulPareto(1000, loc, vario)

#Evaluate risk functional
sums <- sapply(obs, sum)

#Define weighting function
weigthFun <- function(x, u){
x * (1 - exp(-(sum(x) / u - 1)))
}

#Define partial derivative of weighting function
dWeigthFun <- function(x, u){
(1 - exp(-(sum(x) / u - 1))) + (x / u) * exp( - (sum(x) / u - 1))
}

#Select exceedances
threshold <- quantile(sums, 0.9)
exceedances <- obs[sums > threshold]

#Evaluate gradient score function
scoreEstimation(exceedances, loc, vario, weigthFun, dWeigthFun, u = threshold)
}
\references{
Fondeville, R. de and Davison A. (2016). High-dimensional Peaks-over-threshold Inference for Brown-Resnick Processes. Submitted.
}
