% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mverse.R
\name{execute_multiverse}
\alias{execute_multiverse}
\alias{execute_multiverse.mverse}
\title{Execute the entire multiverse.}
\usage{
execute_multiverse(.mverse)

\method{execute_multiverse}{mverse}(.mverse)
}
\arguments{
\item{.mverse}{a \code{mverse} object.}
}
\value{
The resulting \code{mverse} object.
}
\description{
This method executes the analysis steps
defined in the \code{mverse} objected
across the entire multiverse.
}
\examples{
# Define a mutate branch.
hurricane_strength <- mutate_branch(
  # damage vs. wind speed vs.pressure
  NDAM,
  HighestWindSpeed,
  Minpressure_Updated_2014,
  # Standardized versions
  scale(NDAM),
  scale(HighestWindSpeed),
  -scale(Minpressure_Updated_2014),
)
# Create a mverse and add the branch.
mv <- create_multiverse(hurricane) \%>\%
  add_mutate_branch(hurricane_strength)
# The branched variables are not populated across the multiverse yet.
# Execute the multiverse; the variables are populated after the execution.
execute_multiverse(mv)
}
