% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_branch.R
\name{mutate_branch}
\alias{mutate_branch}
\title{Create a new mutate branch.}
\usage{
mutate_branch(..., name = NULL)
}
\arguments{
\item{...}{branch definition expressions.}

\item{name}{(optional) Name for the new variable.}
}
\value{
a mutate_branch object.
}
\description{
Create a new mutate branch.
}
\examples{
# Define mutate branches.
hurricane_strength <- mutate_branch(
  # damage vs. wind speed vs.pressure
  NDAM,
  HighestWindSpeed,
  Minpressure_Updated_2014,
  # Standardized versions
  scale(NDAM),
  scale(HighestWindSpeed),
  -scale(Minpressure_Updated_2014),
)
# Create a mverse and add the branch.
mv <- create_multiverse(hurricane) \%>\%
  add_mutate_branch(hurricane_strength)
}
\seealso{
Other mutate branch functions: 
\code{\link{add_mutate_branch}()}
}
\concept{mutate branch functions}
