% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract}
\alias{extract}
\alias{extract.mverse}
\title{Extract branched values.}
\usage{
extract(...)

\method{extract}{mverse}(
  .mverse,
  columns = NULL,
  nuni = NULL,
  frow = NULL,
  include_branch_options = TRUE,
  ...
)
}
\arguments{
\item{...}{Ignored.}

\item{.mverse}{a \code{mverse} object.}

\item{columns}{a character vector of column names to extract.}

\item{nuni}{a positive integer for the number of universes to extract.}

\item{frow}{proportion of rows to extract from each universe.}

\item{include_branch_options}{when \code{TRUE} (default), include the mutate
statements used to specified the options for each branched columns}
}
\value{
a tibble containing the selected columns
  across the multiverse.
}
\description{
\code{extract} returns a tibble of selected values
across the multiverse in a long format.
}
\details{
This method extracts data values across
the multiverse. You can specify a subset of data
to extract using \code{columns}, \code{universe},
 \code{nuni}, and \code{frow}.

You can specify the columns to extract from each
universe by passing the column names as a character
vector to \code{columns}. The default values is
\code{NULL} extracting all columns with branches.

Use \code{universe} to specify a set of universes
by their integer ids. Use \code{nuni} to specify
the number of universes to extract data from. The
method then selects the subset randomly. Specifying
\code{universe} manually will override \code{nuni} value.
By default, they are both set to \code{NULL} and
the method returns data from all universes.

Use \code{frow} to randomly extract a fraction of
data from each universe. The default value is \code{NULL}
and all rows are returned as they are. Note if you select
1 the method will return shuffle rows in each universe
before returning them. If \code{frow} is greater than 1,
the method randomly samples rows with replacement.
}
\examples{
# Define mutate branches.
hurricane_strength <- mutate_branch(
  # damage vs. wind speed vs.pressure
  NDAM,
  HighestWindSpeed,
  Minpressure_Updated_2014,
  # Standardized versions
  scale(NDAM),
  scale(HighestWindSpeed),
  -scale(Minpressure_Updated_2014),
)
y <- mutate_branch(
  alldeaths, log(alldeaths + 1)
)
# Create a mverse and add the branches.
mv <- create_multiverse(hurricane) \%>\%
  add_mutate_branch(hurricane_strength, y)
execute_multiverse(mv)
# Extract all branched columns from all universes
extract(mv)
# Specify the columns to extract from each universe using columns
# You can select both branched and non-branched columns
extract(mv, columns = c("hurricane_strength", "NDAM"))
# Specify the universe to extract from using universe
extract(mv, universe = 1)
# Specify the number of universes to extract from using nuni
# The universes are randomly selected
extract(mv, nuni = 3)
# Specify the proportion of data to extract from each universe using
# frow. The rows are randomly selected
extract(mv, frow = 0.7)
}
