% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.mvgam_forecast.R
\name{score.mvgam_forecast}
\alias{score.mvgam_forecast}
\alias{score}
\title{Compute probabilistic forecast scores for mvgam objects}
\usage{
\method{score}{mvgam_forecast}(
  object,
  score = "crps",
  log = FALSE,
  weights,
  interval_width = 0.9,
  n_cores = 1,
  ...
)

score(object, ...)
}
\arguments{
\item{object}{\code{mvgam_forecast} object. See \code{\link[=forecast.mvgam]{forecast.mvgam()}}.}

\item{score}{\code{character} specifying the type of proper scoring rule to use for evaluation. Options are:
\code{sis} (i.e. the Scaled Interval Score), \code{energy}, \code{variogram}, \code{elpd}
(i.e. the Expected log pointwise Predictive Density),
\code{drps} (i.e. the Discrete Rank Probability Score) or \code{crps} (the Continuous Rank Probability Score).
Note that when choosing \code{elpd}, the supplied object must have forecasts on the \code{link} scale so that
expectations can be calculated prior to scoring. For all other scores, forecasts should be supplied
on the \code{response} scale (i.e. posterior predictions)}

\item{log}{\code{logical}. Should the forecasts and truths be logged prior to scoring?
This is often appropriate for comparing
performance of models when series vary in their observation ranges}

\item{weights}{optional \code{vector} of weights (where \code{length(weights) == n_series})
for weighting pairwise correlations when evaluating the variogram score for multivariate
forecasts. Useful for down-weighting series that have larger magnitude observations or that
are of less interest when forecasting. Ignored if \code{score != 'variogram'}}

\item{interval_width}{proportional value on \verb{[0.05,0.95]} defining the forecast interval
for calculating coverage and, if \code{score = 'sis'}, for calculating the interval score}

\item{n_cores}{\code{integer} specifying number of cores for calculating scores in parallel}

\item{...}{Ignored}
}
\value{
a \code{list} containing scores and interval coverages per forecast horizon.
If \code{score \%in\% c('drps', 'crps', 'elpd')},
the list will also contain return the sum of all series-level scores per horizon. If
\code{score \%in\% c('energy','variogram')}, no series-level scores are computed and the only score returned
will be for all series. For all scores apart from \code{elpd}, the \code{in_interval} column in each series-level
slot is a binary indicator of whether or not the true value was within the forecast's corresponding
posterior empirical quantiles. Intervals are not calculated when using \code{elpd} because forecasts
will only contain the linear predictors
}
\description{
Compute probabilistic forecast scores for mvgam objects
}
\examples{
\donttest{
# Simulate observations for three count-valued time series
data <- sim_mvgam()
# Fit a dynamic model using 'newdata' to automatically produce forecasts
mod <- mvgam(y ~ 1,
            trend_model = RW(),
            data = data$data_train,
            newdata = data$data_test,
            chains = 2)

# Extract forecasts into a 'mvgam_forecast' object
fc <- forecast(mod)

# Compute Discrete Rank Probability Scores and 0.90 interval coverages
fc_scores <- score(fc, score = 'drps')
str(fc_scores)
}
}
\seealso{
\code{\link{forecast.mvgam}}, \code{\link{ensemble}}
}
