% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mvlinks}
\alias{mvlinks}
\alias{mvprobit}
\alias{mvlogit}
\title{Multivariate link functions in mvord}
\usage{
mvprobit()

mvlogit(df = 8L)
}
\arguments{
\item{df}{integer specifying the degrees of freedom of the t copula}
}
\description{
Different \code{link} functions are available in \pkg{mvord}:
}
\details{
We allow for two different link functions, the multivariate probit
link and the multivariate logit link.
For the multivariate probit
link a multivariate normal distribution for the errors is applied. The
normal bivariate probabilities which enter the pairwise log-likelihood
are computed with the package \pkg{pbivnorm}.

For the multivariate logit link a \eqn{t} copula based multivariate
distribution with logistic margins is used.
  The \code{mvlogit()} function has an optional integer valued argument
\code{df} which specifies the degrees of freedom to be used for the
\eqn{t} copula.  The default value of the degrees of freedom parameter is
8. We restrict the degrees of freedom to be integer valued because the
most efficient routines for computing bivariate \eqn{t}~probabilities do
not support non-integer degrees of freedom. For further details see vignette.
}
