% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{joint_probabilities}
\alias{joint_probabilities}
\title{Extracts fitted Probabilities for Multivariate Ordinal Regression Models.}
\usage{
joint_probabilities(object, response.cat, type = "prob", subjectID = NULL,
  ...)
}
\arguments{
\item{object}{an object of class \code{'mvord'}.}

\item{response.cat}{vector or matrix with response categories (for each subject one row of length equal to the number of multiple measurements).}

\item{type}{\code{"prob"} for joint probabilities and \code{"cum.prob"} for joint cumulative probabilities.}

\item{subjectID}{(optional) vector specifying for which subjectIDs the predictions\cr or fitted values should be computed.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Extracts fitted probabilities for given response categories from a fitted model of class \code{'mvord'}.
}
\details{
The current implementation supports only in-sample predictions.
The row names of the output correspond to the subjectIDs.
}
\seealso{
\code{\link{predict.mvord}}, \code{\link{marginal_predict}}
}
