% Generated by roxygen2 (4.0.1): do not edit by hand
\name{makeSignals}
\alias{makeBlocks}
\alias{makeBumps}
\alias{makeCusp}
\alias{makeDoppler}
\alias{makeLIDAR}
\alias{makeSignals}
\title{Generate test signals for simulation}
\usage{
makeLIDAR(n)

makeBumps(n)

makeDoppler(n)

makeCusp(n)

makeBlocks(n)
}
\arguments{
\item{n}{An integer specifying the length of the desired signal.}
}
\value{
A numeric vector of length n giving the desired test signal.
}
\description{
Generates some of the test signals used the standard nonparametric deconvolution literature.
}
\examples{
n <- 1024
x <- (1:n)/n
signal <- makeLIDAR(n)
plot(x, signal, main = 'LIDAR test signal', type = 'l')
signal <- makeBumps(n)
plot(x, signal, main = 'LIDAR test signal', type = 'l')
signal <- makeDoppler(n)
plot(x, signal, main = 'Doppler test signal', type = 'l')
signal <- makeCusp(n)
plot(x, signal, main = 'Cusp test signal', type = 'l')
signal <- makeBlocks(n)
plot(x, signal, main = 'Blocks test signal', type = 'l')
}

