% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvers.R, R/virgo.R, R/rmwcs.R,
%   R/rnc_sgmwcs.R, R/annealing.R
\name{solve_mwcsp}
\alias{solve_mwcsp}
\alias{solve_mwcsp.virgo_solver}
\alias{solve_mwcsp.rmwcs_solver}
\alias{solve_mwcsp.rnc_solver}
\alias{solve_mwcsp.simulated_annealing_solver}
\title{Solves a MWCS instance.}
\usage{
solve_mwcsp(solver, instance, ...)

\method{solve_mwcsp}{virgo_solver}(solver, instance, ...)

\method{solve_mwcsp}{rmwcs_solver}(solver, instance, max_cardinality = NULL, budget = NULL, ...)

\method{solve_mwcsp}{rnc_solver}(solver, instance, ...)

\method{solve_mwcsp}{simulated_annealing_solver}(solver, instance, warm_start, ...)
}
\arguments{
\item{solver}{a solver object returned by rmwcs_solver, annealing_solver, rnc_solver or virgo_solver.}

\item{instance}{an MWCS instance, an igraph object with problem-related vertex, edge and graph attributes. See details.}

\item{...}{other arguments to be passed.}

\item{max_cardinality}{integer maximum number of vertices in solution.}

\item{budget}{numeric maximum budget of solution.}

\item{warm_start}{warm start solution, an object of the class mwcsp_solution.}
}
\value{
An object of class \code{mwcsp_solution} consisting of resulting subgraph,
its weight and other information about solution provided.
}
\description{
Generic function for solving MWCS instances using solvers collected in the package.
}
\details{
MWCS instance here is represented as an undirected graph, an \code{igraph} object.
The package supports four types of instances: Simple MWCS, Generalized MWCS,
Budget MWCS, signal MWCS problems. All the necessary weights and costs are
passed by setting vertex and edge attributes. See \link{get_instance_type} to check
if the \code{igraph} object is a correct MWCS instance. For Simple MWCS problem
numeric vertex attribute \code{weight} must be set. For generalized version \code{weight}s
can be provided for edges. For budget version of the problem in addition to
vertex weights it is required that \code{igraph} object would have \code{budget_cost} vertex
attribute with positive numeric values.

Signal MWCS instance is quite different. There is no \code{weight} attribute for
neither vertices nor edges. Instead, vertex and edge attribute \code{signal} should
be provided with signal names. A numeric vector containing weights for the signals
should be assigned to graph attribute \code{signals}.

See vignette for description of the supported problems. See \code{igraph} package
documentation for more details about getting/setting necesasry attributes.
}
\examples{

library(igraph)

# for a MWCS instance

data(mwcs_example)
head(V(mwcs_example)$weight)

# for a GMWCS instance
data(gmwcs_example)
head(E(gmwcs_example)$weight)

# for a SGMWCS instance
data(sgmwcs_example)
head(V(sgmwcs_example)$signal)
head(E(sgmwcs_example)$signal)

head(sgmwcs_example$signals)

}
