% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnrichmentTest.R
\name{EnrichmentTest}
\alias{EnrichmentTest}
\title{Phylostratum or Divergence Stratum Enrichment of a given Gene Set based on Fisher's Test}
\usage{
EnrichmentTest(ExpressionSet, test.set, use.only.map = FALSE,
  measure = "log-foldchange", complete.bg = TRUE, epsilon = 1e-05)
}
\arguments{
\item{ExpressionSet}{a standard PhyloExpressionSet or DivergenceExpressionSet object.}

\item{test.set}{a character vector storing the gene ids for which PS/DS enrichment analyses should be performed.}

\item{use.only.map}{a logical value indicating whether instead of a standard \code{ExpressionSet} only a \code{Phylostratigraphic Map} or \code{Divergene Map} is passed to this function.}

\item{measure}{a character string specifying the measure that should be used to quantify over and under representation of PS/DS. Measures can either be \code{measure = "foldchange"} (odds) or \code{measure = "log-foldchange"} (log-odds).}

\item{complete.bg}{a logical value indicating whether the entire background set of the input ExpressionSet should be considered when performing Fisher's exact test (\code{complete.bg = TRUE}) or whether genes that are stored in test.set should be excluded from the background set before performing Fisher's exact test (\code{complete.bg = FALSE}).}

\item{epsilon}{a small value to shift values by epsilon to avoid log(0) computations.}
}
\description{
This function computes the significance of enriched (over or underrepresented) Phylostrata or Divergence Strata within an input \code{test.set} based on the \code{\link{fisher.test}}. Please concult \code{\link{PlotEnrichment}} for details.
}
\examples{

data(PhyloExpressionSetExample)

set.seed(123)
test_set <- sample(PhyloExpressionSetExample[ , 2],1000)

E.Result <- EnrichmentTest(ExpressionSet = PhyloExpressionSetExample,
                           test.set      = test_set ,
                           measure       = "log-foldchange")
                           
# get the log-fold change table
E.Result$enrichment.matrix

# get P-values for the enrichment significance for each Phylostratum
E.Result$p.values

}
\author{
Hajk-Georg Drost
}
\seealso{
\code{\link{PlotEnrichment}}, \code{\link{fisher.test}}
}

