% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gis.R
\name{parse_geocoding_quality_codes}
\alias{parse_geocoding_quality_codes}
\title{Parse the 14 values from the \code{geocodingQualityCodeDetail} field}
\usage{
parse_geocoding_quality_codes(value)
}
\arguments{
\item{value}{Character vector of values from the
\code{geocodingQualityCodeDetail} field.
Each value should be 14 characters long or \code{NA}.}
}
\value{
A \code{data.frame} with the following columns:
  \describe{
    \item{\code{geocodingQualityInputType}}{
      (\code{factor}) Type of address given to geocoder.
      Has the following levels:
      \code{"full address"},
      \code{"street only"},
      \code{"number, no street"},
      \code{"city only"},
      \code{"zip and city"},
      \code{"zip only"},
      \code{"error"}
    }
    \item{\code{geocodingQualityStreetType}}{
      (\code{factor}) Type of street for address.
      Has the following levels:
      \code{"street"},
      \code{"PO box"},
      \code{"rural route"},
      \code{"highway contract route"},
      \code{"star route"},
      \code{"error"}
    }
    \item{\code{geocodingQualityStreet}}{
      (\code{factor}) Quality of match for the street name.
      Has the following levels:
      \code{"100\% match"},
      \code{"soundex match"},
      \code{"street name different"},
      \code{"missing street name"},
      \code{"error"}
    }
    \item{\code{geocodingQualityZip}}{
      (\code{factor}) Quality of match for the ZIP code.
      Has the following levels:
      \code{"100\% match"},
      \code{"5th digit different"},
      \code{"4th digit different"},
      \code{"3rd digit different"},
      \code{"2nd digit different"},
      \code{"1st digit different"},
      \code{"more than one digit different"},
      \code{"invalid ZIP"},
      \code{"error"}
    }
    \item{\code{geocodingQualityCity}}{
      (\code{factor}) Quality of match for the city name.
      Has the following levels:
      \code{"100\% match"},
      \code{"alias match"},
      \code{"soundex match"},
      \code{"no match"},
      \code{"error"}
    }
    \item{\code{geocodingQualityCityRefs}}{
      (\code{factor}) Number of city reference data sets that don't match the
      geocoding result.
      Has the following levels:
      \code{"all match"},
      \code{"1 reference unmatched"},
      \code{"2 to 4 references unmatched"},
      \code{"5 or more references unmatched"},
      \code{"no references matched"},
      \code{"error"}
    }
    \item{\code{geocodingQualityDirectionals}}{
      (\code{factor}) Whether the street directionals are present in the
      input and feature data sets.
      Has the following levels:
      \code{"all match"},
      \code{"missing feature pre and post directionals"},
      \code{"missing input pre and post directionals"},
      \code{"both pre and post directionals do not match"},
      \code{"feature missing post directional"},
      \code{"input missing post directional"},
      \code{"post directionals do not match"},
      \code{"missing feature pre directional"},
      \code{"missing feature pre directional and input post directional"},
      \code{"missing feature pre directional and post directionals do not match"},
      \code{"missing input pre directional"},
      \code{"missing input pre directional and missing feature post directional"},
      \code{"missing input pre directional and post directionals do not match"},
      \code{"pre directionals do not match"},
      \code{"pre directionals do not match and missing feature post directional"},
      \code{"pre directionals do not match and missing input post directional"}
    }
    \item{\code{geocodingQualityQualifiers}}{
      (\code{factor}) Whether the address qualifiers are present in the input
      and feature data sets.
      Has the following levels:
      \code{"all match"},
      \code{"missing feature pre and post qualifiers"},
      \code{"missing input pre and post qualifiers"},
      \code{"both pre and post qualifiers do not match"},
      \code{"feature missing post qualifier"},
      \code{"input missing post qualifier"},
      \code{"post qualifiers do not match"},
      \code{"missing feature pre qualifier"},
      \code{"missing feature pre qualifier and input post qualifier"},
      \code{"missing feature pre qualifier and post qualifiers do not match"},
      \code{"missing input pre qualifier"},
      \code{"missing input pre qualifier and missing feature post qualifier"},
      \code{"missing input pre qualifier and post qualifiers do not match"},
      \code{"pre qualifiers do not match"},
      \code{"pre qualifiers do not match and missing feature post qualifier"},
      \code{"pre qualifiers do not match and missing input post qualifier"}
    }
    \item{\code{geocodingQualityDistance}}{
      (\code{factor}) Average distance between the possible matched parcels
      and their respective possible matched streets.
      Has the following levels:
      \code{"< 10m"},
      \code{"10m-100m"},
      \code{"100m-500m"},
      \code{"500m-1km"},
      \code{"1km-5km"},
      \code{"> 5km"},
      \code{"error"}
    }
    \item{\code{geocodingQualityOutliers}}{
      (\code{factor}) Distribution of distances between the possible matched
      parcels and their respective possible matched streets.
      Has the following levels:
      \code{"100\% within 10m"},
      \code{"60\% within 10m and 40\% within 100m"},
      \code{"60\% within 10m and 40\% within 500m"},
      \code{"60\% within 10m and 40\% within 1km"},
      \code{"60\% within 10m and 40\% within 5km"},
      \code{"60\% within 10m and at least 1 over 5km exists"},
      \code{"30\% within 10m and 70\% within 100m"},
      \code{"30\% within 10m and 70\% within 500m"},
      \code{"30\% within 10m and 70\% within 1km"},
      \code{"30\% within 10m and 70\% within 5km"},
      \code{"30\% within 10m and at least 1 over 5km exists"},
      \code{"error"}
    }
    \item{\code{geocodingQualityCensusBlockGroups}}{
      (\code{factor}) Consistency of geocoded result against Census Block
      Group references.
      Has the following levels:
      \code{"all match"},
      \code{"at least one reference different"},
      \code{"no Census data"},
      \code{"error"}
    }
    \item{\code{geocodingQualityCensusTracts}}{
      (\code{factor}) Consistency of geocoded result against Census Tract
      references.
      Has the following levels:
      \code{"all match"},
      \code{"at least one reference different"},
      \code{"no Census data"},
      \code{"error"}
    }
    \item{\code{geocodingQualityCensusCounties}}{
      (\code{factor}) Consistency of geocoded result against Census County
      references.
      Has the following levels:
      \code{"all match"},
      \code{"at least one reference different"},
      \code{"no Census data"},
      \code{"error"}
    }
    \item{\code{geocodingQualityRefMatchCount}}{
      (\code{integer}) Number of reference data sets matched by geocoding
      result.
    }
  }
}
\description{
Parse the 14 values from the \code{geocodingQualityCodeDetail} field
}
