% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_naaccr.R
\name{write_naaccr_xml}
\alias{write_naaccr_xml}
\title{Write records to a NAACCR-formatted XML file}
\usage{
write_naaccr_xml(
  records,
  con,
  version = NULL,
  format = NULL,
  base_dictionary = NULL,
  user_dictionary = NULL,
  encoding = "UTF-8"
)
}
\arguments{
\item{records}{A \code{naaccr_record} object.}

\item{con}{Either a character string naming a file or a
\code{\link[base:connections]{connection}} open for writing.}

\item{version}{An integer specifying the NAACCR format version for parsing
the records. Use this or \code{format}, not both. If both \code{version}
and \code{format} are \code{NULL} (the default), the most recent version is
used.}

\item{format}{A \code{\link{record_format}} object for writing the records.}

\item{base_dictionary}{URI for the dictionary defining the NAACCR data items.
If this is \code{NULL} and either \code{version} is not \code{NULL} or
\code{format} is one of the standard NAACCR formats, then the URI from
NAACCR's website for that version's dictionary will be used.}

\item{user_dictionary}{URI for the dictionary defining the user-specified
data items.  If \code{NULL} (default), it won't be included in the XML.}

\item{encoding}{String specifying the character encoding for the output file.}
}
\description{
Write records to a NAACCR-formatted XML file
}
