% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naaccr_factor.R
\name{split_sequence_number}
\alias{split_sequence_number}
\title{Unpack tumor sequence number data}
\usage{
split_sequence_number(x)
}
\arguments{
\item{x}{Vector (usually character) of sequence number codes.}
}
\value{
A \code{data.frame} with three columns:
  \describe{
    \item{sequenceNumber}{
      (\code{integer}) The number of the tumor in chronological sequence for
      the patient.
    }
    \item{reportable}{
      (\code{logical}) If \code{TRUE}, then the tumor is required to be
      reported by SEER/NPCR standards. If \code{FALSE}, it is either
      non-malignant or defined as reportable by the registry.
    }
    \item{onlyTumor}{
      (\code{logical}) If \code{TRUE}, this is the only known
       SEER/NPCR-reportable or the only known non-SEER/NPCR-reportable tumor
       for the patient.
    }
    \item{sequenceFlag}{
      (\code{factor}) Special flags, such as unknowns or changes in reporting
      requirements. Created using \code{\link{split_sentineled}}.
    }
  }
}
\description{
Separate the multiple types of information in \code{sequenceNumberCentral}
and \code{sequenceNumberHospital} into multiple columns.
}
\seealso{
\code{\link{split_sentineled}}
}
