% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isregion.R
\name{is_state}
\alias{is_state}
\title{Test an Object for States}
\usage{
is_state(x)
}
\arguments{
\item{x}{A vector to be tested.}
}
\value{
A logical vector.of same length as the input. If the input object is
not even of type \code{character}, return the object unaltered, with a
warning.
}
\description{
Test an Object for States
}
\details{
An element-wise check of a supplied vector is carried out. To
test an entire vector and return a single boolean value, functions 
such as \code{base::all} or \code{base::any} should be used.
}
\note{
The function throws a warning, when a missing value is among the 
elements. It works only for atomic vectors, throwing an error when this 
is not the case or when \code{NULL} is passed to it.
}
\examples{
all(is_state(naijR::states()))
is_state(c("Maryland", "Baden-Baden", "Plateau", "Sussex"))

}
