% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_html.R
\name{drop_html}
\alias{drop_html}
\title{drop_html}
\usage{
drop_html(
  work_item,
  include_qr,
  qr_size = 250,
  vc_width = 600,
  output_dir,
  style,
  use_xaringan = FALSE
)
}
\arguments{
\item{work_item}{A data.frame or tibble with nrow(work_item) == 1 containing the
data for one reference to create the visual citation.}

\item{include_qr}{Character string specifying the way the QR code should be included or if no QR code should be included.
'embed' results in a stand alone <img> tag within the HTML object, other options are ignored for the time being.
'link' (default) creates a PNG of the QR code and stores it in a subfolder of the HTML file's location. The HTML <img> tag links to this file then.
'link_svg' creates a SVG of the QR code and stores it in a subfolder of the HTML file's location. The HTML <img> tag links to this file then.
'none' creates no QR code.}

\item{qr_size}{Specifies the height/width of the rendered QR code in px. Default: 250px, minimum: 150px. Ignored for SVG output.}

\item{vc_width}{Specifies the width of the text part of the visual citation in px.
This can be adjusted to accommodate e.g. untypically long or short titles. Default: 600px}

\item{output_dir}{A string specifying the relative path, where the rendered output files should be stored.}

\item{style}{A string specifying the desired style for the visual citation. Possible values are:
"modern", "classic", "clean", "none". If "none" is given, the returned html can use a custom css file provided by the user.
This custom CSS file must specify styles for <div> classes "top-row", "title-row" and "author-row".}

\item{use_xaringan}{Boolean to specify if an HTML output is intended to be included in an HTML presentation (like e.g. xaringan) or not.
When including the visual citation via htmltools::includeHTML(), the QR code needs to be in a subfolder
relative to the rendered presentation, not relative to the visual citation.}
}
\value{
A htmltools taglist containing the visual citation as HTML representation including style.
}
\description{
Accepts bibliographic information and returns a htmltools tagList for printing/display.
}
