% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{send}
\alias{send}
\title{Send}
\usage{
send(socket, data, block = FALSE, echo = TRUE)
}
\arguments{
\item{socket}{a Socket.}

\item{data}{an R object, which will be sent serialized.}

\item{block}{[default FALSE] logical flag whether to block until successful
or return immediately even if unsuccessful (e.g. no connection available).}

\item{echo}{[default TRUE] logical flag whether to return the raw vector of
sent data. Set to FALSE for performance-critical applications where
invisble NULL will be returned instead.}
}
\value{
Raw vector of sent data, or invisible NULL if 'echo' is set to FALSE.
}
\description{
Send data over a Socket. For sending and receiving within R. Objects are sent
    serialized to ensure perfect reproducibility.
}
\examples{
pub <- socket("pub", dial = "inproc://nanonext")

send(pub, data.frame(a = 1, b = 2))

close(pub)

}
