% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ncurl}
\alias{ncurl}
\title{ncurl}
\usage{
ncurl(http, ...)
}
\arguments{
\item{http}{the URL address.}

\item{...}{(optional) additional arguments, see 'methods' section below.}
}
\value{
Named list of 2 elements:
    \itemize{
    \item{\code{$raw}} {- raw vector of the received resource (use
    \code{\link{writeBin}} to save to a file).}
    \item{\code{$data}} {- converted character string (if a recognised text
    format), or NULL otherwise. Other tools can be used to further parse this
    as html, json, xml etc. if required.}
    }
}
\description{
nano cURL - a minimalist http(s) client.
}
\section{Methods}{


    Additional arguments may be passed in using '...' for HTTP methods other
    than GET.
    \itemize{
    \item{Parsed as follows: [method], [content-type], [data]}
    \item{Example: "POST", "text/plain", "hello world"}
    \item{All 3 arguments must be supplied, and will be ignored otherwise, as
    will extra arguments}
    }
}

\section{Redirects}{


    In interactive sessions: will prompt upon receiving a redirect location
    whether to follow or not (default: yes).

    In non-interactive sessions: redirects are never followed.
}

\section{TLS Support}{


    Connecting to secure https sites is supported if \code{\link{nng_version}}
    shows 'TLS supported'.
}

\examples{
ncurl("http://httpbin.org/get")
ncurl("http://httpbin.org/post", "POST", "text-plain", "hello world")

}
