% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{pipe_notify}
\alias{pipe_notify}
\title{Pipe Notify}
\usage{
pipe_notify(socket, cv, add = FALSE, remove = FALSE, flag = FALSE)
}
\arguments{
\item{socket}{a Socket.}

\item{cv}{a \sQuote{conditionVariable} to signal, or NULL to cancel a
previously set signal.}

\item{add}{[default FALSE] logical value whether to signal (or cancel signal)
when a pipe is added.}

\item{remove}{[default FALSE] logical value whether to signal (or cancel
signal) when a pipe is removed.}

\item{flag}{[default FALSE] logical value whether to also set a flag in the
\sQuote{conditionVariable}. This can help distinguish between different
types of signal, and causes any subsequent \code{\link{wait}} to return
FALSE instead of TRUE. If a signal from the \pkg{tools} package, e.g.
\code{tools::SIGINT}, or an equivalent integer value is supplied, this sets
a flag and additionally raises this signal upon the flag being set.}
}
\value{
Invisibly, zero on success (will otherwise error).
}
\description{
Signals a \sQuote{conditionVariable} whenever pipes (individual connections)
are added or removed at a socket.
}
\details{
For add: this event occurs after the pipe is fully added to the socket. Prior
to this time, it is not possible to communicate over the pipe with the socket.

For remove: this event occurs after the pipe has been removed from the socket.
The underlying transport may be closed at this point, and it is not possible
to communicate using this pipe.
}
\examples{
s <- socket(listen = "inproc://nanopipe")
cv <- cv()

pipe_notify(s, cv, add = TRUE, remove = TRUE, flag = TRUE)
cv_value(cv)

s1 <- socket(dial = "inproc://nanopipe")
cv_value(cv)
reap(s1)
cv_value(cv)

pipe_notify(s, NULL, add = TRUE, remove = TRUE)
s1 <- socket(dial = "inproc://nanopipe")
cv_value(cv)
reap(s1)

(wait(cv))

close(s)

}
