% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.R
\name{emr_time2date}
\alias{emr_time2date}
\title{Convert from internal time to year, month, day, hour}
\usage{
emr_time2date(time)
}
\arguments{
\item{time}{vector of times in internal format}
}
\value{
a data frame with columns named 'year', 'month', 'day' and 'hour'
}
\description{
Convert from internal time to year, month, day, hour
}
\examples{

emr_db.init_examples()

# 30 January, 1938, 6:00 - birthday of Islam Karimov
t1 <- emr_date2time(30, 1, 1938, 6)
# September 2, 2016, 7:00 - death of Islam Karimov
t2 <- emr_date2time(2, 9, 2016, 7)
emr_time2date(c(t1, t2))
}
