% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtrack.R
\name{emr_vtrack.name}
\alias{emr_vtrack.name}
\title{Generate a default name for a virtual track}
\usage{
emr_vtrack.name(
  src,
  func = NULL,
  params = NULL,
  keepref = FALSE,
  time.shift = NULL,
  id.map = NULL,
  filter = NULL
)
}
\arguments{
\item{src}{a character vector specifying the source dataset(s) or filter(s) that the virtual track is based on}

\item{func}{a character vector specifying the function(s) applied to the source data to generate the virtual track}

\item{params}{a named list specifying the parameters used by the function(s) to generate the virtual track}

\item{keepref}{a logical value indicating whether the virtual track should keep the reference column(s) of the source data}

\item{time.shift}{a numeric vector specifying the time shift(s) applied to the virtual track}

\item{id.map}{a named list specifying the mapping of the IDs between the source data and the virtual track}

\item{filter}{a character vector specifying the filter(s) applied to the virtual track. Note that the filter name cannot contain the character '.'}
}
\value{
a default name for the virtual track
}
\description{
Given virtual track parameters, generate a name with the following format:
"vt_{src}.func_{func}.params_{params}.kr{keepref}.ts_{time.shift}.id_{id.map}.filter_{filter}"
Where for 'params', 'time.shift', and 'id.map', the values are separated by an
underscore.
}
\details{
If \code{func}, \code{params}, \code{time.shift}, \code{id.map}, or \code{filter} are
\code{NULL} - their section would not appear in the generated name.
}
\examples{

emr_db.init_examples()
emr_vtrack.name("dense_track",
    time.shift = 1,
    func = "max"
)

}
\seealso{
\code{\link{emr_vtrack.create}}
}
\keyword{track}
\keyword{~virtual}
