% Generated by roxygen2 (4.0.2): do not edit by hand
\name{nblast_allbyall}
\alias{nblast_allbyall}
\alias{nblast_allbyall.character}
\alias{nblast_allbyall.neuronlist}
\title{Wrapper function to compute all by all NBLAST scores for a set of neurons}
\usage{
nblast_allbyall(x, ...)

\method{nblast_allbyall}{character}(x, smat = NULL,
  db = getOption("nat.default.neuronlist"), ...)

\method{nblast_allbyall}{neuronlist}(x, smat = NULL, distance = FALSE,
  normalisation = c("raw", "normalised", "mean"), ...)
}
\arguments{
\item{x}{Input neurons (neuronlist or character vector)}

\item{...}{Additional arguments for methods or \code{nblast}}

\item{smat}{the scoring matrix to use (see details of \code{\link{nblast}}
for meaning of default \code{NULL} value)}

\item{db}{A neuronlist or a character vector naming one. Defaults to value of
options("nat.default.neuronlist")}

\item{distance}{logical indicating whether to return distances or scores.}

\item{normalisation}{the type of normalisation procedure that should be
carried out, selected from  \code{'raw'}, \code{'normalised'} or
\code{'mean'} (i.e. the average of normalised scores in both directions).
If \code{distance=TRUE} then this cannot be raw.}
}
\description{
Calls \code{nblast} to compute the actual scores. Can accept
  either a neuronlist or neuron names as a character vector. This is a thin
  wrapper around nblast and its main advantage is the option of "mean"
  normalisation for forward and reverse scores, which is the most sensible
  input to give to a clustering algorithm as well as the choice of returning
  a distance matrix.
}
\details{
Note that \code{nat} already provides a function
  \code{\link{nhclust}} for clustering, which is a wrapper for R's
  \code{hclust} function. \code{nhclust} actually expects \bold{raw} scores
  as input.
}
\section{TODO}{
 It would be a good idea in the future to implement a parallel
  version of this function.
}
\examples{
library(nat)
kcs20.scoremat=nblast_allbyall(kcs20)
kcs20.hclust=nhclust(scoremat=kcs20.scoremat)
plot(kcs20.hclust)
}
\seealso{
\code{\link{nblast}, \link{sub_score_mat}, \link{nhclust}}
}

