% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dist_matrix.R
\name{create_dist_matrix}
\alias{create_dist_matrix}
\title{Create matrix of distances between strata}
\usage{
create_dist_matrix(...)
}
\arguments{
\item{...}{any number of matrices that contain the distances between levels of
a single stratifying factor. These should have both column and row names
which correspond to the levels of the stratifying factor.}
}
\value{
Matrix containing the distances between all levels of the factor of all
interactions between the inputted factors. The row and column names correspond
to the levels of the strata, formed by combining the level name of each stratifying
factor separated with `:`.
}
\description{
Create a distance matrix between strata levels created from the interactions
of factors. Used as input to \code{\link{generate_qs}()}.
}
\examples{

data('nh0506')

age_cat <- cut(nh0506$age,
               breaks = c(19, 39, 50, 85),
               labels = c('< 40 years', '40 - 50 years', '> 50 years'))

age_dist <- matrix(data = c(0, 1, 2, 1, 0, 1, 2, 1, 0),
                   nrow = 3,
                   byrow = TRUE,
                   dimnames = list(levels(age_cat), levels(age_cat)))

sex_dist <- matrix(data = c(0, 1, 1, 0),
                   nrow = 2,
                   dimnames = list(levels(nh0506$sex), levels(nh0506$sex)))

strata_dist <- create_dist_matrix(age_dist, sex_dist)
}
