% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activate.R
\name{activate}
\alias{activate}
\alias{activate.menu}
\alias{activate.item}
\alias{deactivate}
\alias{deactivate.menu}
\alias{deactivate.item}
\title{Activate/deactivate a menu item}
\usage{
activate(.data, ..., .add = FALSE)

\method{activate}{menu}(.data, ..., .add = FALSE)

\method{activate}{item}(.data, ..., .add = FALSE)

deactivate(x, ..., deep = TRUE)

\method{deactivate}{menu}(x, ..., deep = TRUE)

\method{deactivate}{item}(x, ..., deep = TRUE)
}
\arguments{
\item{.data}{A menu.}

\item{...}{In \code{activate()}, one or more variables passed to \code{\link[dplyr:pull]{dplyr::pull()}}.
In \code{deactivate()}, unused (for extensibility).}

\item{.add}{Whether to add new variables to the path indices.
If \code{FALSE} (default value), the menu will be deactivated first by \code{\link[=deactivate]{deactivate()}}.}

\item{x}{A \code{menu} object.}

\item{deep}{If \code{TRUE} (default value), deactivate recursively.}
}
\value{
In \code{activate()}, An \code{item} object.
If it inherits from class \code{menu}, the menu will be displayed hierarchically.
Otherwise, the active data will be displayed.
In \code{deactivate()}, A \code{menu} object.
}
\description{
Activates a menu item with the same syntax as \code{\link[dplyr:pull]{dplyr::pull()}}.
Activating a menu item allows you to perform operations on the active item.
\code{activate()} turns a \code{menu} object into an \code{item} object,
and \code{deactivate()} turns it back.
}
\examples{
library(dplyr)

mn1 <- new_menu(key = c("band_members", "band_instruments"),
                value = list(band_members, band_instruments))

mn1 \%>\%
  activate(band_members) \%>\%
  filter(band == "Beatles")

# Items can also be specified as integers
mn1 \%>\%
  activate(2)

mn1 \%>\%
  activate(-1) \%>\%
  deactivate()

# To activate items in a nested menu, specify multiple variables
mn2 <- new_menu(key = c("key1", "key2"),
                value = list(mn1, mn1))
mn2 \%>\%
  activate(key1, band_members)

}
