% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb_sum_moments.R
\name{nb_sum_moments}
\alias{nb_sum_moments}
\title{Implements the method of moments approximation for the sum of arbitrary NB random variables. Called by other functions. Not intended to be run alone.}
\usage{
nb_sum_moments(mus, phis, counts)
}
\arguments{
\item{mus}{Vector of individual mean values.}

\item{phis}{Vector of individual dispersion parameters. Equivalent to 'size' in dnbinom.}

\item{counts}{The vector of counts over which the PMF is evaluated.}
}
\value{
A numeric vector of probability densities.
}
\description{
Implements the method of moments approximation for the sum of arbitrary NB random variables. Called by other functions. Not intended to be run alone.
}
\examples{
nb_sum_moments(mus = c(100, 10), phis = c(5, 8), counts = 0:500)

}
