% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{nc.get.dim.axes.from.names}
\alias{nc.get.dim.axes.from.names}
\title{Infer dimension axes from names of dimensions}
\usage{
nc.get.dim.axes.from.names(f, v, dim.names)
}
\arguments{
\item{f}{The file (an object of class \code{ncdf4})}

\item{v}{The name of a variable}

\item{dim.names}{Optionally, dimension names (to avoid looking them up repeatedly)}
}
\value{
A named character vector mapping dimension names to axes.
}
\description{
Infer dimension axes from names of dimensions.
}
\details{
This function makes educated guesses as to what axes dimensions may apply to in the case of files with poor metadata.
}
\examples{
## Get dimension axes from file by inferring them from dimension names
\dontrun{
f <- nc_open("pr.nc")
dim.axes <- nc.get.dim.axes.from.names(f, "pr")
nc_close(f)
}

}
