% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfVariable.R, R/ncdfDataset.R
\name{dimlength}
\alias{dimlength}
\alias{dim,ncdfVariable-method}
\alias{dim,ncdfDataset-method}
\title{Lengths of dimensions of the data set or variable}
\usage{
\S4method{dim}{ncdfVariable}(x)

\S4method{dim}{ncdfDataset}(x)
}
\arguments{
\item{x}{An instance of \code{ncdfDataset} or \code{ncdfVariable}.}
}
\value{
Named integer vector of dimension sizes of dimensions in \code{x}.
}
\description{
With this method the lengths of all dimensions of a dataset or a variable are
returned. Note that a dataset may have more dimensions than a variable from
the same dataset: other variables may use different dimensions.
}
\examples{
fn <- system.file("extdata",
  "pr_day_EC-Earth3-CC_ssp245_r1i1p1f1_gr_20240101-20241231_vncdfCF.nc",
  package = "ncdfCF")
ds <- open_ncdf(fn)

# ncdfDataset
dim(ds)

# ncdfVariable
dim(ds[["pr"]])
}
