% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfDimensionTime.R
\name{has_bounds,ncdfDimensionTime-method}
\alias{has_bounds,ncdfDimensionTime-method}
\title{Does the "time" dimension have 'bounds' set?}
\usage{
\S4method{has_bounds}{ncdfDimensionTime}(x)
}
\arguments{
\item{x}{The \code{ncdfDimensionTime} object to query.}
}
\value{
Logical to flag if bounds have been set or not.
}
\description{
Does the "time" dimension have 'bounds' set?
}
\examples{
fn <- system.file("extdata",
                  "pr_day_EC-Earth3-CC_ssp245_r1i1p1f1_gr_20240101-20241231_vncdfCF.nc",
                  package = "ncdfCF")
ds <- open_ncdf(fn)
time <- ds[["time"]]
has_bounds(time)
}
