% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFAxisDiscrete.R
\docType{class}
\name{CFAxisDiscrete}
\alias{CFAxisDiscrete}
\title{CF discrete axis object}
\description{
This class represent discrete CF axes, i.e. those axes whose
coordinate values do not represent a physical property. The coordinate
values are ordinal values equal to the index into the axis.
}
\section{Super classes}{
\code{\link[ncdfCF:CFObject]{ncdfCF::CFObject}} -> \code{\link[ncdfCF:CFAxis]{ncdfCF::CFAxis}} -> \code{CFAxisDiscrete}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}

\item{\code{dimnames}}{(read-only) The coordinates of the axis as an integer
vector, or labels for every axis element if they have been set.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFAxisDiscrete-new}{\code{CFAxisDiscrete$new()}}
\item \href{#method-CFAxisDiscrete-brief}{\code{CFAxisDiscrete$brief()}}
\item \href{#method-CFAxisDiscrete-indexOf}{\code{CFAxisDiscrete$indexOf()}}
\item \href{#method-CFAxisDiscrete-clone}{\code{CFAxisDiscrete$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="append_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-append_attribute'><code>ncdfCF::CFObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attribute'><code>ncdfCF::CFObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="delete_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-delete_attribute'><code>ncdfCF::CFObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="print_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-print_attributes'><code>ncdfCF::CFObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="set_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-set_attribute'><code>ncdfCF::CFObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="write_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-write_attributes'><code>ncdfCF::CFObject$write_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="label_set"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-label_set'><code>ncdfCF::CFAxis$label_set()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="peek"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-peek'><code>ncdfCF::CFAxis$peek()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="print"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-print'><code>ncdfCF::CFAxis$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="shard"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-shard'><code>ncdfCF::CFAxis$shard()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="sub_axis"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-sub_axis'><code>ncdfCF::CFAxis$sub_axis()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="time"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-time'><code>ncdfCF::CFAxis$time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="write"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-write'><code>ncdfCF::CFAxis$write()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisDiscrete-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisDiscrete-new}{}}}
\subsection{Method \code{new()}}{
Create a new instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisDiscrete$new(grp, nc_var, nc_dim, orientation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{grp}}{The group that contains the netCDF variable.}

\item{\code{nc_var}}{The netCDF variable that describes this instance.}

\item{\code{nc_dim}}{The netCDF dimension that describes the dimensionality.}

\item{\code{orientation}}{The orientation (\code{X}, \code{Y}, \code{Z}, or \code{T}) or \code{""} if
different or unknown.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisDiscrete-brief"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisDiscrete-brief}{}}}
\subsection{Method \code{brief()}}{
Some details of the axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisDiscrete$brief()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 1-row \code{data.frame} with some details of the axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisDiscrete-indexOf"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisDiscrete-indexOf}{}}}
\subsection{Method \code{indexOf()}}{
Find indices in the axis domain. Given a vector of numerical
values \code{x}, find their indices in the values of the axis. In effect,
this returns index values into the axis, but outside values will be
dropped.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisDiscrete$indexOf(x, method = "constant")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Vector of numeric values to find axis indices for.}

\item{\code{method}}{Ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Numeric vector of the same length as \code{x}. Values of \code{x} outside
of the range of the values in the axis are returned as \code{0} and
\code{.Machine$integer.max}, respectively.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisDiscrete-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisDiscrete-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisDiscrete$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
