% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VirtualGroup.R
\docType{class}
\name{VirtualGroup}
\alias{VirtualGroup}
\title{CF group in memory}
\description{
This class represents a CF group in memory. It descends from
\link{NCGroup} and functions as such with the exception that it has no
associated \code{CFResource} and the \code{handle} field thus always returns \code{NULL}.
}
\section{Super classes}{
\code{\link[ncdfCF:NCObject]{ncdfCF::NCObject}} -> \code{\link[ncdfCF:NCGroup]{ncdfCF::NCGroup}} -> \code{VirtualGroup}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}

\item{\code{handle}}{Return NULL as a VirtualGroup has no resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-VirtualGroup-new}{\code{VirtualGroup$new()}}
\item \href{#method-VirtualGroup-clone}{\code{VirtualGroup$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="append_attribute"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-append_attribute'><code>ncdfCF::NCObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="attribute"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-attribute'><code>ncdfCF::NCObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="delete_attribute"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-delete_attribute'><code>ncdfCF::NCObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="print_attributes"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-print_attributes'><code>ncdfCF::NCObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="set_attribute"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-set_attribute'><code>ncdfCF::NCObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="write_attributes"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-write_attributes'><code>ncdfCF::NCObject$write_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="addAuxiliaryLongLat"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-addAuxiliaryLongLat'><code>ncdfCF::NCGroup$addAuxiliaryLongLat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="axes"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-axes'><code>ncdfCF::NCGroup$axes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="dimensions"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-dimensions'><code>ncdfCF::NCGroup$dimensions()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="find_by_name"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-find_by_name'><code>ncdfCF::NCGroup$find_by_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="find_dim_by_id"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-find_dim_by_id'><code>ncdfCF::NCGroup$find_dim_by_id()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="fullnames"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-fullnames'><code>ncdfCF::NCGroup$fullnames()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="grid_mappings"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-grid_mappings'><code>ncdfCF::NCGroup$grid_mappings()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="hierarchy"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-hierarchy'><code>ncdfCF::NCGroup$hierarchy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="print"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-print'><code>ncdfCF::NCGroup$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="unused"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-unused'><code>ncdfCF::NCGroup$unused()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="variables"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-variables'><code>ncdfCF::NCGroup$variables()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VirtualGroup-new"></a>}}
\if{latex}{\out{\hypertarget{method-VirtualGroup-new}{}}}
\subsection{Method \code{new()}}{
Create an instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VirtualGroup$new(id, name, fullname, parent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The identifier of the group.}

\item{\code{name}}{The name of the group.}

\item{\code{fullname}}{The fully qualified name of the group.}

\item{\code{parent}}{The parent group of this group. The \code{parent} of the root
group is \code{NULL}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VirtualGroup-clone"></a>}}
\if{latex}{\out{\hypertarget{method-VirtualGroup-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VirtualGroup$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
