\name{Sncf2D}
\alias{Sncf2D}
\title{Anisotropic nonparametric (cross-)correlation function for spatio-temporal data}
\description{
  Sncf2D is the function to estimate the anisotropic nonparametric correlation function 
  in 8 (or arbitrary) directions (North - Southeast). Correlation functions are 
  calculated for each different bearing. The function requires multiple observations at each location. 
  (use \code{\link{spline.correlog.2D}} otherwise).  
}

\usage{
Sncf2D(x, y, z, w = NULL, df = NULL, type = "boot", resamp = 1000, 
npoints = 300, save = FALSE, max.it = 25, xmax = FALSE, na.rm = FALSE,
jitter = FALSE, angle = c(0, 22.5, 45, 67.5, 90, 112.5, 135, 157.5))
}

\arguments{
  \item{x}{vector of length n representing the x coordinates.}
  \item{y}{vector of length n representing the y coordinates.}
  \item{z}{matrix of dimension n x p representing p observation at each location.}
  \item{w}{an optional second matrix of dimension n x p for variable 2 
    (to estimate spatial or lagged cross-correlation functions).}
  \item{df}{degrees of freedom for the spline. Default is sqrt(n).}
  \item{type}{takes the value "boot" (default) to generate a bootstrap
    distribution or "perm" to generate a null distribution for the estimator}
 \item{resamp}{the number of resamples for the bootstrap or the
    null distribution. }
  \item{npoints}{the number of points at which to save the
           value for the spline function (and confidence
           envelope / null distribution). }
  \item{save}{if TRUE the whole matrix of output from the
           resampling is saved (an resamp x npoints
           dimensional matrix). }
  \item{max.it}{the maximum iteration for the Newton method
           used to estimate the intercepts.}
  \item{xmax}{if FALSE the max observed in the data is used.
       Otherwise all distances greater than xmax is
       omitted.}
  \item{na.rm}{if TRUE, NA's will be dealt with through
           pairwise deletion of missing values for each
           pair of time series -- it will dump if any one
           pair has less than two (temporally) overlapping
           observations.}
  \item{jitter}{if TRUE, jitters the distance matrix, to avoid problems associated
    with fitting the function to data on regular grids}
  \item{angle}{specifies number of cardinal directions and angles for which to 
  calculate correlation functions. Default are 8 directions between 0 and 180.}
}

\details{
  Correlation functions are calculated on projected distances onto the different 
  bearings so ALL data are used for each direction. The (obsolete?) \code{oldncf2D} used the alternative 
  of slizing up the data like pieces of a pie.
  
  Latitude-longitude coordinates can NOT be used.
  
  Missing values are allowed - values are assumed missing at random.

  I have implemented an optional argument:
  \item{jitter}{if TRUE this jitters distance matrix, to avoid some problems I've had 
    with spline-smoothing data from regular grid-data.}
}

\value{
  An object of class "Sncf2D" is returned, consisting of a list of estimates for
  each cardinal direction :
  \item{real}{The list of estimates from the data.}
  \item{$cbar}{the regional average correlation.}
  \item{$x.intercept}{the lowest value at which the function is = 0. 
    If correlation is initially negative, the distance is given as negative.}
  \item{$e.intercept}{the lowest value at which the function 1/e.}
  \item{$y.intercept}{the extrapolated value at x=0 (nugget).}
  \item{$cbar.intercept}{distance at which regional average
        correlation is reach.}
  \item{$predicted$x}{the x-axes for the fitted covariance function.}
  \item{$predcited$y}{the values for the covariance function.}

  \item{boot}{A list with the analogous output from the 
              bootstrap or null distribution.} 
  \item{$summary}{gives the full vector of output for the
              x.intercept, 
              y.intercept, 
              e.intercept, 
              cbar.intercept, 
              and the cbar and a quantile summary for 
              the resampling distribution.}
  \item{$boot}{if save=TRUE the full raw matrices from the 
              resampling is saved.}
  \item{angle}{A vector with the cardinal directions.}
  \item{max.distance}{the maximum spatial distance.}
} 

\note{
The function to estimate the anisotropic nonparametric (cross-)correlation function 
  in arbitrary directions. In particular it was developed to calculate the 
  lagged cross-correlation function (Bjornstad et al. 2002).
}

\references{
Bjornstad, O. N., M. Peltonen, A. M. Liebhold, and W. Baltensweiler. 2002. Waves 
of larch budmoth outbreaks in the European Alps. Science 298:1020-1023.
}

\author{Ottar N. Bjornstad \email{onb1@psu.edu}}

\seealso{\code{\link{summary.Sncf2D}} 
\code{\link{plot.Sncf2D}}
\code{\link{cc.offset}} 
\code{\link{Sncf}}
\code{\link{spline.correlog.2D}}
}

\examples{
#first generate some sample data
    x <- expand.grid(1:20, 1:5)[,1]
    y <- expand.grid(1:20, 1:5)[,2]
#z data from an exponential random field
    z <- cbind(
        rmvn.spa(x=x, y=y, p=2, method="exp"),
        rmvn.spa(x=x, y=y, p=2, method="exp")
        )
#anisotorpic nonparametric covariance function at 30 and 60 degrees
    fit1 <- Sncf2D(x=x, y=y, z=z, resamp = 0, angle=c(30, 60))
    \dontrun{plot.Sncf2D(fit1)}
    summary.Sncf2D(fit1)
    
    #What distance is the peak in correlation
    cc.offset(fit1)
}

\keyword{smooth}
\keyword{regression}
