% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc_meta.R
\name{nc_meta}
\alias{nc_meta}
\alias{nc_meta}
\alias{nc_meta.NetCDF}
\alias{nc_meta}
\alias{nc_meta.character}
\title{Top level NetCDF metadata.}
\usage{
nc_meta(x, ...)

\method{nc_meta}{NetCDF}(x, ...)

\method{nc_meta}{character}(x, ...)
}
\arguments{
\item{x}{data source address, file name or handle}

\item{...}{ignored}
}
\description{
This function exists to maintain the open connection
while all dimension, variable, and attribute metadata is extracted.
}
\details{
This function is pretty ambitious, and will send nearly any string
to the underlying NetCDF library other than "", which immediately
generates an error. This should be robust, but might present fairly
obscure error messages from the underlying library.
}
\examples{
f <- system.file("extdata", "S2008001.L3m_DAY_CHL_chlor_a_9km.nc", package = "ncmeta")
nc_meta(f)
\donttest{
\dontrun{
u <- "https://upwell.pfeg.noaa.gov/erddap/tabledap/FRDCPSTrawlLHHaulCatch"
nc_meta(u)
}}
}
