% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_util.R
\name{to.indicators}
\alias{to.indicators}
\title{Construct Indicator Matrix}
\usage{
to.indicators(vec, exclude.base = TRUE, base = NULL, prefix = NULL)
}
\arguments{
\item{vec}{a categorical vector.}

\item{exclude.base}{\code{FALSE} means to include all the categories. \code{TRUE}
means to exclude one category as a base case.
 If \code{base} is not specified, a random category will be removed.}

\item{base}{a base category removed from the indicator matrix. This option works
only when the \code{type} variable is set to \code{"exclude.base"}.}

\item{prefix}{a prefix to be used for column names of the output matrix.
Default is "cat_" if \code{prefix} is \code{NULL}.
For example, if a category vector has values of c("a", "b", "c"),
column names of the output matrix will be "cat_aa", "cat_bb" and "cat_cc".
If \code{vec} is a \code{\link{data.frame}} and \code{prefix} is \code{NULL},
then the \code{vec}'s column name followed by "_" will be used as a prefix.}
}
\value{
This returns an object of \code{\link{matrix}} which contains indicators.
}
\description{
\code{to.indicators} converts a categorical variable into a \code{\link{data.frame}}
with indicator (0 or 1) variables for each category.
}
\examples{
a1 = 4:10;
b1 = c("aa", "bb", "cc");

to.indicators(a1, base = 10);
to.indicators(b1, base = "bb", prefix = "T_");
to.indicators(as.data.frame(b1), base = "bb");



}
