## ------------------------------------------------------------------------
## Linear regression
data(prostate)
X <- as.matrix(prostate[,1:8])
y <- prostate$lpsa
head(X)
head(y)

## ------------------------------------------------------------------------
fit <- ncvreg(X, y)

## ----opts.label='fig'----------------------------------------------------
plot(fit)

## ----opts.label='fig'----------------------------------------------------
coef(fit, lambda=0.1)

## ----opts.label='fig'----------------------------------------------------
cvfit <- cv.ncvreg(X, y)
plot(cvfit)

## ------------------------------------------------------------------------
coef(cvfit)

## ------------------------------------------------------------------------
predict(cvfit, X=head(X))
predict(cvfit, type="nvars")

