% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dir.R
\name{read_dir}
\alias{read_dir}
\title{Read and Merge Files from Directory}
\usage{
read_dir(
  pattern = "*[.]",
  path = ".",
  reader_function = utils::read.table,
  ...,
  subdirs = FALSE,
  filt = NULL,
  hush = FALSE
)
}
\arguments{
\item{pattern}{Regular expression ("regex"; as string or \code{NULL}) for
selecting files (passed to the \code{\link{list.files}} function). The
default \code{NULL} means that all files at the specified path will be read
in. To select, for example, a specific extension like ".txt", the pattern
can be given as \code{"\\.txt$"} (for CSV files, \code{"\\.csv$"}, etc.).
Files ending with e.g. "group2.txt" can be specified as
\code{"group2\\.txt$"}. Files starting with "exp3" can be specified as
\code{"^exp3"}. Files starting with "exp3" AND ending with ".txt" extension
can be specified as \code{"^exp3.*\\.txt$"}. To read in a single file,
specify the full filename (e.g. \code{"exp3_subject46_group2.txt"}). (See
\code{?regex} for more details.)}

\item{path}{Path to the directory from which the files should be selected and
read. The default \code{"."} means the current working directory (as
returned by \code{\link{getwd}()}). Either specify correct working directory
in advance (see \code{\link{setwd}}, \code{\link{path_neat}}), or otherwise
enter relative or full paths (e.g. \code{"C:/research"} or
\code{"/home/projects"}, etc.).}

\item{reader_function}{A function to be used for reading the files,
\code{\link[utils:read.table]{utils::read.table}} by default.}

\item{...}{Any arguments to be passed on to the chosen \code{reader_function}.}

\item{subdirs}{Logical (\code{FALSE} by default). If \code{TRUE}, searches
files in subdirectories as well (relative to the given \code{path}).}

\item{filt}{An expression to filter, by column values, each data file after it
is read and before it is merged with the other data. (The expression should
use column names alone; see Examples.)}

\item{hush}{Logical. If \code{FALSE} (default), prints lists all data file
names as they are being read (along with related warnings).}
}
\description{
Reads data files from any given directory as data frames and
  merges them into a single data frame (using
  \code{\link[plyr:rbind.fill]{plyr:rbind.fill}}).
}
\note{
This function is very similar to the \code{readbulk::read_bulk}
 function. One important difference however is the possibility of
 pre-filtering by file (see \code{filt}). Data files could include
 significant amount of unnecessary data, and filtering prevents these to be
 merged. Another important difference is the possibility of file selection
 based on any regex \code{pattern}.
}
\examples{
\donttest{

# first, set current working directory
# e.g. to script's path with setwd(path_neat())

# read all text files in currect working directory
merged_df = read_dir("\\\\.txt$")
# merged_df now has all data

# some advisable options passed to read.table
merged_df = read_dir(
    '\\\\.txt$',
    header = TRUE,
    fill = TRUE,
    quote = "\"",
    stringsAsFactors = FALSE
)
}

}
\seealso{
\code{\link[plyr:rbind.fill]{plyr:rbind.fill}}
}
