% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createNetworks.R
\name{createNetworks}
\alias{createNetworks}
\title{Create Networks Using Edge Data Frame}
\usage{
createNetworks(edge_df)
}
\arguments{
\item{edge_df}{A data frame where each row represents a different network and
where each column represents a potential edge between node A and node B.
The column names should be of the form "XA_B", where A and B are the node
numbers in the network. If Node A or B do not exist in the specific
network, the cell should have a value of NA. If there is no edge between A
and B, place a value of 0. Avoid redundant column names since all edges are
assumed to be undirected, e.g. avoid "XA_B" and "XB_A".}
}
\description{
\code{createNetworks} creates Igraph network objects using an edge data
  frame. This is important for computing structural properties of the 
  networks to be explored by \code{\link{neatmap}}.
}
\author{
Philippe Boileau, \email{philippe_boileau@berkeley.edu}
}
