% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nemSymBMinout.R
\name{nemSymBMinout}
\alias{nemSymBMinout}
\title{Network evolution model with a prespecified blockmodel type and partition (symmetric networks with incomers and outgoers)}
\usage{
nemSymBMinout(
  X = X,
  partition = partition,
  M = M,
  formula = NULL,
  theta = NULL,
  nin = 5,
  nout = 20,
  minClusterSize = 5,
  k = 1000,
  loops = FALSE,
  randomizeP = 0,
  randomSD = 0.02
)
}
\arguments{
\item{X}{Initial binary network; of class \code{matrix}.}

\item{partition}{A desired partition in a vector format. Each unique value (positive integers) represents one cluster.}

\item{M}{Desired image matrix with block densities.}

\item{formula}{The list of local netork mechanisms to be considered.}

\item{theta}{A vector with the mechanisms' weights/strengths.}

\item{nin}{Number of incomers.}

\item{nout}{Number of outgoers.}

\item{minClusterSize}{Minimum cluster size.}

\item{k}{Number of iterations.}

\item{loops}{Wheter loops are allowed or not (default \code{FALSE}).}

\item{randomizeP}{The share of units to be randomly relocated between clusters.}

\item{randomSD}{The srandard deviation of a normal distribution form which the random part of weighed network statistics is sampled.}
}
\value{
The list with the following elements:
\itemize{
\item \code{initialNetwork} - Initial network; of class \code{matrix}.
\item \code{finalNetwork} - Final (generated) network; of class \code{matrix}.
\item \code{initialPartition} - Initial partition.
\item \code{finalPartition} - Final partition (i.e., partition after randomization and after incomers and outgoers).
\item \code{M} - The desired (specified) image matrix.
\item \code{k} - The number of iterations.
\item \code{combinedPartitions} - Data frame with initial and final partition.
\item \code{whenIncomers} - A vector of which elements tells us at which iterations the incomers were added.
\item \code{whenOutgoers} - A vector of which elements tells us at which iterations the outgoers were removed.
\item \code{ERR} - Sum of squared differences between the desired and empirical densities across blocks; for each iteration.
\item \code{linkERR} - The difference in the number of links between the generated number of links and desired number of links; for each iteration.
}
}
\description{
Generate a symmetric network with a selected blockmodel type and partition 
with a specified number of incomers and outgoers. Considers local network mechanisms when
creating links within blocks.
}
\examples{
formula <- list(mutuality, popularity, OTPtransitivity)
X <- matrix(sample(c(0,1), size = 9**2, replace = TRUE), nrow = 9)
diag(X) <- 0
M <- matrix(c(0.1, 0.8, 0.8, 0.1), nrow = 2)
partition <- c(1, 2, 2, 1, 1, 2, 2, 2, 1)
nemSymBMinout(X = X, 
              partition = partition, 
              formula = formula, 
              theta = c(1, 1, 1), 
              M = M, 
              k = 100, 
              minClusterSize = 2,
              nin = 10,
              nout = 5,
              loops = FALSE)
}
\author{
Marjan Cugmas and Aleš Žiberna
}
