% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nemsqar_situation_table.R
\docType{data}
\name{nemsqar_situation_table}
\alias{nemsqar_situation_table}
\title{Synthetic Test Data for eSituation Fields in National EMS Information System}
\format{
A data frame with 10,000 rows and 18 variables:
\describe{
\item{Incident Patient Care Report Number - PCR (eRecord.01)}{Unique identifier for the incident report (character).}
\item{Incident Date}{Date of the incident (Date).}
\item{Situation Symptom Onset Date Time (eSituation.01)}{Date and time when symptoms began (datetime).}
\item{Situation Possible Injury With Code (eSituation.02)}{Indicates whether an injury is possible, including coded response (character).}
\item{Situation Complaint Type (eSituation.03)}{Classification of the patient's complaint (character).}
\item{Situation Complaint Statement (eSituation.04)}{Primary complaint reported by the patient (character).}
\item{Situation Primary Complaint Statement List (eSituation.04)}{List of primary complaints (character).}
\item{Situation Complaint Duration (eSituation.05)}{Duration of the complaint (numeric).}
\item{Situation Complaint Duration Time Units (eSituation.06)}{Units of time associated with the complaint duration (character).}
\item{Situation Chief Complaint Anatomic Location (eSituation.07)}{Anatomic location of the primary complaint (character).}
\item{Situation Chief Complaint Organ System (eSituation.08)}{Organ system affected by the chief complaint (character).}
\item{Situation Primary Symptom (eSituation.09)}{Primary symptom reported by the patient, including ICD code (character).}
\item{Situation Other Associated Symptom Description (eSituation.10)}{Description of additional symptoms (character).}
\item{Situation Other Associated Symptom ICD Code (eSituation.10)}{ICD code for associated symptoms (character).}
\item{Situation Other Associated Symptoms List (eSituation.10)}{List of additional symptoms reported (character).}
\item{Situation Provider Primary Impression Code And Description (eSituation.11)}{Primary impression of the provider, including ICD code (character).}
\item{Situation Provider Secondary Impression Description And Code (eSituation.12)}{Secondary provider impression, including ICD code (character).}
\item{Situation Provider Secondary Impression Description And Code List (eSituation.12)}{List of secondary provider impressions (character).}
}
}
\usage{
data(nemsqar_situation_table)
}
\description{
This dataset provides completely synthetic test data for evaluating situation-related
functions in the \code{nemsqar} package. It includes variables related to patient complaints,
symptoms, injury status, and provider impressions. The dataset is designed to
assist users in testing the expected input structure for situation-related measures.
}
\details{
Users are encouraged to test these functions with this dataset, but results
should not be interpreted as meaningful. Some outputs may be nonsensical,
which is expected since this data is only intended to demonstrate the
expected structure of input data.
}
\examples{
data(nemsqar_situation_table)
head(nemsqar_situation_table)

}
\keyword{datasets}
