% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pediatrics_03b.R
\name{pediatrics_03b}
\alias{pediatrics_03b}
\title{Pediatrics-03B Calculation}
\usage{
pediatrics_03b(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  exam_table = NULL,
  medications_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  eexam_01_col,
  eexam_02_col,
  emedications_03_col,
  emedications_04_col,
  ...
)
}
\arguments{
\item{df}{A data frame or tibble containing emergency response records.
Default is \code{NULL}.}

\item{patient_scene_table}{A data.frame or tibble containing only ePatient
and eScene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data.frame or tibble containing only the eResponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{exam_table}{A data.frame or tibble containing only the eExam fields
needed for this measure's calculations. Default is \code{NULL}.}

\item{medications_table}{A data.frame or tibble containing only the
eMedications fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{erecord_01_col}{Column for unique EMS record identifiers.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column giving the calculated age value.}

\item{epatient_16_col}{Column giving the provided age unit value.}

\item{eresponse_05_col}{Column containing the EMS response codes.}

\item{eexam_01_col}{Column containing documented weight information.}

\item{eexam_02_col}{Another column for weight documentation, if applicable.}

\item{emedications_03_col}{Column indicating medication administration.}

\item{emedications_04_col}{Column listing medications administered.}

\item{...}{Additional parameters for the \code{dplyr::summarize} output.}
}
\value{
A tibble summarizing results for three population groups (All,
Adults, and Peds) with the following columns:

\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (All, Adults, Peds).
\code{numerator}: Count of incidents
where patient weight was documented.
\code{denominator}: Total count of
incidents.
\code{prop}: Proportion of incidents where patient weight was
documented.
\code{prop_label}: Proportion formatted as a percentage with a
specified number of decimal places.
}
\description{
The function calculates a pediatric metric focused on EMS responses,
specifically targeting responses that involve patients under 18 years of age,
where certain weight-based medications were administered. This function
filters EMS data to identify relevant 911 responses and further narrows down
the dataset to cases involving children, calculating the proportion of cases
with documented weight among those where weight-based medications were
administered.
}
\examples{

# Synthetic test data
test_data <- tibble::tibble(
  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  incident_date = as.Date(c("2025-01-01", "2025-01-05", "2025-02-01",
  "2025-06-01", "2025-12-15")),
  patient_dob = as.Date(c("2021-01-01", "2020-01-01", "2022-02-01",
  "2023-06-01", "2019-12-15")),
  epatient_15 = c(4, 5, 3, 2, 6),  # Ages
  epatient_16 = c("Years", "Years", "Years", "Years", "Years"),
  eresponse_05 = rep(2205001, 5),
  emedications_03 = rep("stuff", 5),
  emedications_04 = c("Inhalation", "pill", "liquid", "pill", "liquid"),
  eexam_01 = c(60, 59, 58, 57, 56),
  eexam_02 = c("Red", "Purple", "Grey", "Yellow", "Orange")
)

# Run function
pediatrics_03b(
  df = test_data,
  erecord_01_col = erecord_01,
  incident_date_col = incident_date,
  patient_DOB_col = patient_dob,
  epatient_15_col = epatient_15,
  epatient_16_col = epatient_16,
  eresponse_05_col = eresponse_05,
  emedications_03_col = emedications_03,
  emedications_04_col = emedications_04,
  eexam_01_col = eexam_01,
  eexam_02_col = eexam_02
)


}
\author{
Nicolas Foss, Ed.D., MS
}
